
using System;
using System.Collections.Generic;
using System.Linq;
using MonoTouch.Foundation;
using MonoTouch.UIKit;

namespace iXTankeniOS
{
	public partial class AddNewTankViewController : UIViewController
	{
		private AddNewViewModel viewModel;
		
		#region Constructors

		// The IntPtr and initWithCoder constructors are required for items that need 
		// to be able to be created from a xib rather than from managed code

		public AddNewTankViewController (IntPtr handle) : base(handle)
		{
			Initialize ();
		}

		[Export("initWithCoder:")]
		public AddNewTankViewController (NSCoder coder) : base(coder)
		{
			Initialize ();
		}

		public AddNewTankViewController () : base("AddNewTankViewController", null)
		{
			Initialize ();
		}

		void Initialize ()
		{
			viewModel = new AddNewViewModel();
		}
		
		#endregion
		
		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			
			this.NavigationItem.Title = "Neu";
			
			UIBarButtonItem cancelButtonItem = new UIBarButtonItem(UIBarButtonSystemItem.Cancel);
			cancelButtonItem.Clicked += CancelButtonItemClicked;
			this.NavigationItem.LeftBarButtonItem = cancelButtonItem;
			
			UIBarButtonItem saveButtonItem = new UIBarButtonItem(UIBarButtonSystemItem.Save);
			saveButtonItem.Clicked += SaveButtonItemClicked;
			this.NavigationItem.RightBarButtonItem = saveButtonItem;
		
			GetDataFromViewModel();
		}

		void SaveButtonItemClicked (object sender, EventArgs e)
		{
			GetDataFromView();
			viewModel.CommitDataAction(null);
		}

		void CancelButtonItemClicked (object sender, EventArgs e)
		{
			viewModel.RollbackDataAction(null);
		}
		
		public override void ViewWillAppear (bool animated)
		{
			base.ViewWillAppear (animated);
			NavigationHelper.CurrentNavigationController = this.NavigationController;
		}
		
		private void GetDataFromViewModel()
		{
			textDatum.Text = viewModel.Datum.ToShortDateString();
			textKilometer.Text = viewModel.Kilometerstand.ToString();
			textMenge.Text = viewModel.Menge.ToString();
			textBetrag.Text = viewModel.Betrag.ToString();
			textAnmerkung.Text = viewModel.Anmerkung;
			
			
		}
		
		private void GetDataFromView()
		{
			viewModel.Datum = Convert.ToDateTime(textDatum.Text); 
			viewModel.Kilometerstand = Convert.ToDouble(textKilometer.Text); 
			viewModel.Menge= Convert.ToDouble(textMenge.Text); 
			viewModel.Betrag= Convert.ToDouble(textBetrag.Text); 
			viewModel.Anmerkung=textAnmerkung.Text;
		}
	}
}

