﻿using System;

namespace LightSwitchApplication
{

 /// <summary>
 /// Drucken via Word
 /// </summary>
 class Drucken
 {

  public static byte[] Teilnahmebestaetigung(Teilnehmer t, Schulung s)
  {

   // Word starten und sichtbar machen
   dynamic wordObject = System.Runtime.InteropServices.Automation.AutomationFactory.CreateObject("Word.Application");

   try
   {
    wordObject.Visible = true;
    // Dokument erzeugen
    dynamic doc = wordObject.Documents.Add();

    // Inhalt erzeugen
    wordObject.Selection.Font.Name = "Arial";
    wordObject.Selection.Font.Bold = true;
    wordObject.Selection.Font.Size = 16;
    wordObject.Selection.TypeText("Teilnahmebestätigung");
    wordObject.Selection.Font.Bold = false;
    wordObject.Selection.Font.Size = 14;
    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeParagraph();

    wordObject.Selection.TypeText("Schulung: " + s.Schulungsthema);
    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeText("Datum: " + s.Beginn.ToShortDateString() + " bis " + s.Ende.ToShortDateString() + " (" + s.Dauer + " Tage)");
    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeText("Preis: " + s.Preis + " Euro");
    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeText("Referent: " + s.Referent.Referentanzeige);

    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeParagraph();

    wordObject.Selection.TypeText("Name: " + t.Teilnehmeranzeige);
    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeText("Firma: " + t.Firma);
    wordObject.Selection.TypeParagraph();
    wordObject.Selection.TypeText("E-Mail: " + t.EMail);
    wordObject.Selection.TypeParagraph();
   }

   catch (Exception e)
   {
    throw new InvalidOperationException("Dokument kann nicht erzeugt werden", e);
   }

   finally
   {

    IDisposable disposable = wordObject as IDisposable;

    if (disposable != null)
    {
     disposable.Dispose();
    }
   }

   return null;
  }

 }

}


