﻿using System;
using System.Linq;
using System.IO;
using System.IO.IsolatedStorage;
using System.Collections.Generic;
using Microsoft.LightSwitch;
using Microsoft.LightSwitch.Framework.Client;
using Microsoft.LightSwitch.Presentation;
using Microsoft.LightSwitch.Presentation.Extensions;
using System.Runtime.InteropServices.Automation;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
namespace LightSwitchApplication
{
 public partial class Schulungsliste
 {
  partial void ExportHTML_Execute()
  {
   try
   {
    // Nach Dateiname fragen
    string DateiName = this.ShowInputBox("Bitte Dateiname eingeben (kein vollständiger Pfad - Datei wird im Standardordner 'Dokumente' abgelegt!", "Export HTML");
    if (DateiName == "") return;
    // Ganze Pfad
    string DateiPfad = System.IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), DateiName);

    // Datei erstellen
    System.IO.StreamWriter sw = new StreamWriter(DateiPfad, true);
    sw.WriteLine("<html><body><table>");
    foreach (var p in this.Schulungen)
    {
     sw.WriteLine("<tr><td>" + p.Schulungsthema + "</td><td>" + p.Beginn + "</td><td>" + p.Ende + "</td><td>" + p.Dauer + "Tage </td><td>" + p.Preis + "</td></tr>");
    }
    sw.WriteLine("</table></body></html>");
    sw.Close();

    if (this.ShowMessageBox("Liste exportiert nach " + DateiPfad + ". Jetzt anzeigen?", "Frage", MessageBoxOption.YesNo) == System.Windows.MessageBoxResult.Yes)
    {
     dynamic shell = AutomationFactory.CreateObject("Wscript.Shell");
     shell.Run(DateiPfad);
    }
   }
   catch (Exception ex)
   {
    this.ShowMessageBox(ex.Message, "Fehler beim HTML Export", MessageBoxOption.Ok);
   }
  }

  partial void ExportHTML_CanExecute(ref bool result)
  {
   result = AutomationFactory.IsAvailable;
  }

  partial void gridEditSelected_CanExecute(ref bool result)
  {
   // Write your code here.

  }

  partial void gridEditSelected_Execute()
  {
   this.Application.ShowSchulungsdetails(this.Schulungen.SelectedItem.Id);
  }

  partial void Schulungsliste_Created()
  {
   // Setzen der Datenbindungen (einmalig)
   this.FindControl("Preis").SetBinding(TextBox.ForegroundProperty, "Value", new FarbConverter(), BindingMode.OneWay);
   this.FindControl("Preis").SetBinding(TextBlock.ForegroundProperty, "Value", new FarbConverter(), BindingMode.OneWay);
  }

  /// <summary>
  /// Konverter, der für jede Zeile bei der Datenbindung wirkt
  /// </summary>
  public class FarbConverter : IValueConverter
  {
   public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
   {
    Decimal ivalue;
    if (value != null && Decimal.TryParse(value.ToString(), out ivalue))
    {
     if (ivalue <= 500)
     {
      return new SolidColorBrush(Colors.Red);
     }
    }
    else
    {
     return new SolidColorBrush(Colors.Red);
    }
    return new SolidColorBrush(Colors.Black);
   }

   public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
   {
    throw new NotImplementedException();
   }
  }
 }
}
