package com.spheroTest.SensorDaten;
 
import java.util.List;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.widget.TextView;
 
import orbotix.robot.app.StartupActivity;
import orbotix.robot.base.*;
import orbotix.robot.sensor.*;
 
public class SensorDatenActivity extends Activity
{

private final static int STARTUP_ACTIVITY = 0;
 
private Robot mRobot;
private TextView acc_x;
private TextView acc_y;
private TextView acc_z;
							
private TextView gyr_x;
private TextView gyr_y;
private TextView gyr_z;
							
private TextView pitchValue;
private TextView yawValue;
private TextView rollValue;

private DeviceMessenger.AsyncDataListener mDataListener = new DeviceMessenger.AsyncDataListener() {
    @Override
    public void onDataReceived(DeviceAsyncData data) {
 
        	if(data instanceof DeviceSensorsAsyncData){
 
            	//Alle Frames der letzten Antwort lesen
            	List<DeviceSensorsData> data_list = ((DeviceSensorsAsyncData)data).getAsyncData();
            	if(data_list != null){
 
                	//Gelesene Frames iterieren und Werte ausgeben
                   	 for(DeviceSensorsData datum : data_list) {
 
                   	   //Rotationswinkel des Spheros
                       AttitudeData spheroRotation = datum.getAttitudeData();
                        if(spheroRotation != null){
                            pitchValue.setText("" + spheroRotation.getAttitudeSensor().pitch);
                            rollValue.setText("" + spheroRotation.getAttitudeSensor().roll);
                            yawValue.setText("" + spheroRotation.getAttitudeSensor().yaw);
                        }

                        //Beschleunigung des Spheros
                        AccelerometerData spheroBeschleunigung = datum.getAccelerometerData();
                        if(spheroBeschleunigung != null){
                        	
                        	acc_x.setText(String.format("%.3f", spheroBeschleunigung.getFilteredAcceleration().x));
                            acc_y.setText(String.format("%.3f",  spheroBeschleunigung.getFilteredAcceleration().y));
                            acc_z.setText(String.format("%.3f",  spheroBeschleunigung.getFilteredAcceleration().z));
                        }
						
						//Daten des Gyroskops
						GyroData spheroGyroskop = datum.getGyroData();
                        if(spheroGyroskop != null){
                            gyr_x.setText(String.format("%.3f", spheroBeschleunigung.getFilteredAcceleration().x));
                            gyr_y.setText(String.format("%.3f",  spheroBeschleunigung.getFilteredAcceleration().y));
                            gyr_z.setText(String.format("%.3f",  spheroBeschleunigung.getFilteredAcceleration().z));
                        }
                  }
    		}
    	}
  }
};
	
private void startStreaming(){
 
    	if(mRobot != null){
 
        	//Die gewnschten Sensordaten werden in eine Bitmaske eingetragen
        	final int sensorMaske = 
        			
        			SetDataStreamingCommand.DATA_STREAMING_MASK_ACCELEROMETER_X_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_ACCELEROMETER_Y_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_ACCELEROMETER_Z_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_IMU_PITCH_ANGLE_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_IMU_ROLL_ANGLE_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_IMU_YAW_ANGLE_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_GYRO_X_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_GYRO_Y_FILTERED |
                    SetDataStreamingCommand.DATA_STREAMING_MASK_GYRO_Z_FILTERED;

 
        	//Die Grundfrequenz der Spherologik von 400hz wird 
			//durch diesen Faktor geteilt, 
			//damit die Daten stabil verarbeitet werden knnen
        	final int teiler = 50;
 
        	//Anzahl der Frames die der Sphero pro Antwork zurck gibt
        	final int packetFrames = 1;
 
        	//Lnge des Streams in Frames. 
			//0 = Stream wird nicht beendet
        	final int anzahlAntworten= 0;
 
        	//Den Sphero anweisen, den Stream zu starten
        	SetDataStreamingCommand.sendCommand(mRobot, teiler, packetFrames, sensorMaske, anzahlAntworten);
 
        	//Der AsyncDataListener bearbeitet die einzelnen Anfragen
	DeviceMessenger.getInstance().addAsyncDataListener(mRobot, mDataListener);
}
}

@Override
public void onCreate(Bundle savedInstanceState)
{
super.onCreate(savedInstanceState);
setContentView(R.layout.main);
}
 
@Override
protected void onStart() {
	super.onStart();
	acc_x = (TextView)findViewById(R.id.acc_x);
	acc_y = (TextView)findViewById(R.id.acc_y);
	acc_z = (TextView)findViewById(R.id.acc_z);
	
	gyr_x = (TextView)findViewById(R.id.gyr_x);
	gyr_y = (TextView)findViewById(R.id.gyr_y);
	gyr_z = (TextView)findViewById(R.id.gyr_z);
	
	pitchValue = (TextView)findViewById(R.id.pitchValue);
	rollValue = (TextView)findViewById(R.id.rollValue);
	yawValue = (TextView)findViewById(R.id.yawValue);
	
	//StartupActivity Objekt initialisieren um Bluetooth Verbindung mit dem Sphero herzustellen
   	Intent i = new Intent(this, StartupActivity.class);
                startActivityForResult(i, STARTUP_ACTIVITY);
}
 
@Override
protected void onActivityResult(int requestCode, int resultCode, Intent data) {

	super.onActivityResult(requestCode, resultCode, data);
    	
    if(requestCode == STARTUP_ACTIVITY && resultCode == RESULT_OK){
 
        	//Wenn die StartupActivity erfolgreich beendet wurde wird die ID des verbundenen Spheros angefordert
        	final String robot_id = data.getStringExtra(StartupActivity.EXTRA_ROBOT_ID);
        	
        	if(robot_id != null && !robot_id.equals("")){
            		mRobot = RobotProvider.getDefaultProvider().findRobot(robot_id);
            	
            		//Den Datenstream initialisieren
            		startStreaming();
 
            		//Die Stabilisierung des Spheros ausschalten, damit dieser in der Hand, ohne kontinuierliche Neuausrichtung frei rotiert werden kann
                	StabilizationCommand.sendCommand(mRobot, false);
            	
     	       		//Zweite LED anschalten
            		FrontLEDOutputCommand.sendCommand(mRobot, 1f);
        		}
    	}
}
 
	
	
@Override
protected void onStop() {
	            	
    	super.onStop();
 
    	//Die Robotereigenschaften zurcksetzen
    	if(mRobot != null){
 
        		StabilizationCommand.sendCommand(mRobot, true);
        		FrontLEDOutputCommand.sendCommand(mRobot, 0f);
 
        		RobotProvider.getDefaultProvider().disconnectControlledRobots();
    	}
}
}

