// Cluster Radius
var radius = 620 / 2;

// Tree-Layout
var tree = d3.layout.tree()
     .size([360, radius - 120])
     .separation(function(a, b) { return (a.parent == b.parent ? 1 : 2) / a.depth; });
 
var diagonal = d3.svg.diagonal.radial()
     .projection(function(d) { return [d.y, d.x / 180 * Math.PI]; });

// SVG Zeichenfläche 
var vis = d3.select("#chart").append("svg")
     .attr("width", radius * 2)
     .attr("height", radius * 2)
     .append("g")
     .attr("transform", "translate(" + radius + "," + radius + ")");

// Einlesen der JSON-Daten 
d3.json("city_spendings.json", function(json) {
  var nodes = tree.nodes(json);

  // zeichnen der Verbindungen 
  var link = vis.selectAll("path.link")
    .data(tree.links(nodes))
    .enter().append("path")
    .attr("class", "link")
    .attr("d", diagonal);
 
  // zeichnen der Cluster
  var node = vis.selectAll("g.node")
    .data(nodes)
    .enter().append("g")
    .attr("class", "node")
    .attr("transform", function(d) { return "rotate(" + (d.x - 90) + ")translate(" + d.y + ")"; })
 
   node.append("circle")
       .attr("r", function(d) { return d.size/15000; });
 
   node.append("text")
       .attr("dx", function(d) { return d.x < 180 ? 25 : -25; })
       .attr("dy", ".31em")
       .attr("text-anchor", function(d) { return d.x < 180 ? "start" : "end"; })
       .attr("transform", function(d) { return d.x < 180 ? null : "rotate(180)"; })
       .text(function(d) { return d.name; });
 });
