﻿var canvas = null;
var context = null;

var gameLoop;
var framePerSecond = 84; //Anzahl Bilder pro Sekunde

var mouseX = -1;
var lastMouseX = -1;
var mousedown = false;

var leftKeyDown = false;
var rightKeyDown = false;

var ball = null;
var paddle = null;

var points = 0;

var isGameRunning = false;

var isDoubleBuffer = false;
var canvasBuffer = null;
var realContext = null;

function Run() { //Startet das Spiel
    canvas = document.getElementById('canvas');
    if (canvas && canvas.getContext) {
        //Canvas und GetContext wird von Browser unterstüzt

        if (!isDoubleBuffer) {
            context = canvas.getContext('2d');
        } else {
            canvasBuffer = document.createElement('canvas');
            canvasBuffer.width  = canvas.width;
            canvasBuffer.height = canvas.height;
            context = canvasBuffer.getContext('2d');
            realContext = canvas.getContext('2d');
        }
        LoadContent();
        Initialize();
        gameLoop = setInterval(DoGameLoop, 1000/framePerSecond);
    }
}

function LoadContent() { //Lädt Bilder, Sound usw.
//    var snd = new Audio("file.mp3");
//    snd.play();
//    myAudio.canPlayType('audio/mpeg')
}

function Initialize() { //Initialisiert das Spiel

    canvas.addEventListener('mousemove', MousemoveHandler, false);
    document.onmousedown = function () { mousedown = true; }
    document.onmouseup = function () { mousedown = false; }
    document.onkeydown = KeyDownHandler;
    document.onkeyup = KeyUpHandler;

    ball = new GameActor(); //Ball
    ball.PositionX = 120.0;
    ball.PositionY = 100.0;
    ball.SpeedX = 120.0/framePerSecond;
    ball.SpeedY = 120.0 / framePerSecond;
    ball.Width = 16.0;
    ball.Height = 16.0;

    paddle = new GameActor(); //Schläger
    paddle.Width = 64.0;
    paddle.Height = 20.0;
    paddle.PositionX = canvas.width / 2 - paddle.Width / 2;
    paddle.PositionY = canvas.height - 3 * paddle.Height;
    paddle.SpeedX = 240.0 / framePerSecond;
    paddle.SpeedY = 240.0 / framePerSecond;

    points = 0;
}

function DoGameLoop() { //Spieleschleife
    Update();
    Draw();
}

function GetPlayerDx() {
    var ergebnis = 0

    //Tastatur
    if (leftKeyDown)
        ergebnis = -1 * paddle.SpeedX;
    if (rightKeyDown)
        ergebnis = paddle.SpeedX;

    //Maus
    if (mousedown && mouseX > 0) {
        if (lastMouseX > -1) {
            ergebnis = mouseX - lastMouseX;
        }
        lastMouseX = mouseX;
    } else {
        mouseX = -1;
        lastMouseX = -1;
    }
    return ergebnis
}

function Update() { //Anwender-Eingaben verarbeiten; Bewegung berechnen

    if (!isGameRunning) {
        return
    }

    //Paddle
    var dx = GetPlayerDx();
    paddle.PositionX = Math.max(paddle.PositionX + dx, 0);
    paddle.PositionX = Math.min(canvas.width - paddle.Width, paddle.PositionX);
    
    //Ball moves
    ball.PositionX = ball.PositionX + ball.SpeedX;
    ball.PositionY = ball.PositionY + ball.SpeedY;

    //Ball reflects above
    if (ball.PositionY <= ball.Height / 2) {
        ball.PositionY = ball.Height/2;
        ball.SpeedY = ball.SpeedY * -1;
        points = points + 1;
    }

    //Ball left and right
    if (ball.PositionX <= ball.Width/2 || ball.PositionX >= canvas.width - ball.Width/2) {
        ball.PositionX = Math.max(ball.Width/2, ball.PositionX);
        ball.PositionX = Math.min(canvas.width - ball.Width/2, ball.PositionX);
        ball.SpeedX *= -1;
        points += 1;
    }

    //Ball hits paddle
    if (ball.PositionY + ball.Height/2 >= paddle.PositionY && ball.PositionY <= paddle.PositionY + paddle.Height) {
        if (ball.PositionX + ball.Height/2 >= paddle.PositionX && ball.PositionX <= paddle.PositionX + paddle.Width) {
            ball.SpeedY *= -1;
            ball.PositionY = paddle.PositionY - ball.Height/2;
        }
    }

    //Ball is out
    if (ball.PositionY - ball.Height/2 >= canvas.height) {
        isGameRunning = false;
        clearInterval(gameLoop);
        setHighScore();
        Run();
    }
}

function Draw() { //Zeichnen

    if (isDoubleBuffer) {
        context.fillStyle = "#FFFFFF";
        context.fillRect(0, 0, canvas.width, canvas.height);
    } else {
        context.clearRect(0, 0, canvas.width, canvas.height); //to transparent black
    }

    context.fillStyle = "#FFE300";
    context.strokeStyle = "#000000";
    context.beginPath();
    context.arc(ball.PositionX, ball.PositionY, ball.Width/2, 0, Math.PI * 2, true);
    context.closePath();
    context.fill();
    context.stroke();

    context.fillStyle = "#FF0000";
    context.fillRect(paddle.PositionX, paddle.PositionY, paddle.Width, paddle.Height);

    context.fillStyle = "#EEF315"
    context.font = "bold 24px sans-serif";

    if (!isGameRunning) {
        context.fillText("Click here to start game", 32, 64);
    }
    context.fillText("Points: " + points, 10, 32);

    if(isDoubleBuffer){
        realContext.drawImage(canvasBuffer, 0, 0);
    }
}

function MousemoveHandler(ev) {
    mouseX = -1;
    // Get the mouse position relative to the canvas element.
    if (ev.layerX || ev.layerX == 0) { // Firefox, IE
        mouseX = ev.layerX;
    } else if (ev.offsetX || ev.offsetX == 0) { // Opera
        mouseX = ev.offsetX;
    }
}

function KeyDownHandler(ev) {

    // links
    if (ev.keyCode == 37)
        leftKeyDown = true;
    // rechts
    if (ev.keyCode == 39)
        rightKeyDown = true;
}

function KeyUpHandler(ev) {
    leftKeyDown = false;
    rightKeyDown = false;
}

function canvasOnClick() {
    isGameRunning = true;
}

function setHighScore() {
    if (!localStorage) {
        alert("Dieser Browser unterstüzt nicht HTML5 localStorage");
    } else {

        var highScore = localStorage["wwpp_HightScore"]; //HighScore lesen
        if (!highScore) //Falls nicht gefunden auf Startwert setzen
            highScore = 0;

        if (points > highScore) // ist der Punktestand ein neuer HighScore
            highScore = points;

        try {
            localStorage["wwpp_HightScore"] = highScore; //speichern
        } catch (e) {
            if (e == QUOTA_EXCEEDED_ERR) {
                alert("Speicherquote für LocalStorage überschritten!");
            }
        } 
    }
}
