package com.thomaskuenneth.artikel.ix.daydreamdemo;

import android.service.dreams.DreamService;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class DaydreamDemo extends DreamService {

	@Override
	public void onAttachedToWindow() {

		// Benutzeraktionen sind mglich
		setInteractive(true);
		// Statuszeile nicht sichtbar
		setFullscreen(true);
		// den Bildschirm nicht dimmen
		setScreenBright(true);
		
		setContentView(R.layout.layout);
		final EditText e = (EditText) findViewById(R.id.edittextfield);
		Button b = (Button) findViewById(R.id.button);

		b.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				String s = e.getText().toString();
				int l = s.length();
				StringBuilder sb = new StringBuilder(l);
				for (int i = 0; i < l; i++) {
					sb.append(s.charAt(l - i - 1));
				}
				e.setText(sb.toString());
			}
		});
	}
}
