package com.thomaskuenneth.artikel.ix.secondarydisplaydemo;

import android.app.Activity;
import android.app.Presentation;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.media.MediaRouter;
import android.media.MediaRouter.RouteInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class MainActivity extends Activity {

	private static final String TAG = MainActivity.class.getSimpleName();

	private Presentation presentation;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		// sekundäre Displays ausgeben
		DisplayManager dm = (DisplayManager) getSystemService(DISPLAY_SERVICE);
		Display[] displays = dm
				.getDisplays(DisplayManager.DISPLAY_CATEGORY_PRESENTATION);
		Rect outSize = new Rect();
		for (Display display : displays) {
			Log.d(TAG, "Name: " + display.getName());
			display.getRectSize(outSize);
			Log.d(TAG, "Breite: " + outSize.width());
			Log.d(TAG, "Höhe: " + outSize.height());
		}

		// Route zu Video-Präsentation ermitteln
		MediaRouter mr = (MediaRouter) getSystemService(MEDIA_ROUTER_SERVICE);
		final RouteInfo ri = mr
				.getSelectedRoute(MediaRouter.ROUTE_TYPE_LIVE_VIDEO);
		presentation = null;

		final Button b = (Button) findViewById(R.id.main_button);
		final Display display = ri.getPresentationDisplay();
		b.setEnabled(display != null);
		b.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (presentation != null) {
					presentation.cancel();
					presentation = null;
				} else if (ri != null) {
					presentation = new MyPresentation(MainActivity.this,
							display);
					presentation.show();
				}
			}
		});
	}
}