/**
 * @file logoRotate.cl
 */

/*
 * Copyright (C) Gemfony scientific UG (haftungsbeschraenkt)
 *
 * Contact: contact [at] gemfony (dot) com
 *
 * This file is part of the LogoRotate program.
 *
 * LogoRotate is free software: you can redistribute and/or modify it under
 * the terms of version 3 of the GNU Affero General Public License
 * as published by the Free Software Foundation.
 *
 * LogoRotate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with the Geneva library. If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information on Gemfony scientific, visit http://www.gemfony.com
 */

__kernel void logo_rotate(
  const __global uchar4 *source
  , __global uchar4 *target
  , float theta
){
  // Retrieve our position in the input image
  float pos_x = (float)(get_global_id(0));
  float pos_y = (float)(get_global_id(1));

  // Perform the (expensive!) trigonometric conversion 
  float sin_theta = sin(theta);
  float cos_theta = cos(theta);

  float shiftX = 0.5f*((float)WIDTH);
  float shiftY = 0.5f*((float)HEIGHT);

  // Rotate the pixel
  float new_pos_x = cos_theta*(pos_x-shiftX) + sin_theta*(pos_y-shiftY) + shiftX;
  float new_pos_y = -1.f*sin_theta*(pos_x-shiftX) + cos_theta*(pos_y-shiftY) + shiftY;

  // Check that we are still in the boundaries of the image.
  // If so, add the new pixel to the target
  if(new_pos_x>=0.f && new_pos_y>=0.f 
     && new_pos_x<(float)WIDTH && new_pos_y<(float)HEIGHT) {
    
    target[((int)new_pos_y)*(WIDTH) + ((int)new_pos_x)] 
      = source[((int)pos_y)*(WIDTH) + (int)pos_x];
  }
}
