/**
 * @file main.cpp
 */

/*
 * Copyright (C) Gemfony scientific UG (haftungsbeschraenkt)
 *
 * Contact: contact [at] gemfony (dot) com
 *
 * This file is part of the LogoRotate program.
 *
 * LogoRotate is free software: you can redistribute and/or modify it under
 * the terms of version 3 of the GNU Affero General Public License
 * as published by the Free Software Foundation.
 *
 * LogoRotate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with the Geneva library. If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information on Gemfony scientific, visit http://www.gemfony.com
 */

#include <cmath>
#include <boost/lexical_cast.hpp>

#include "LogoRotate.hpp"

const int NSTEPS = 16;

int main(int argc, char** argv)
{
  // Initialize our LogoRotate object. This also sets up the context
  LogoRotate lr("logoRotate.cl");
  
  // Rotate the iX logo in a given number of steps 
  // around its middle axis. 
  float angle; int id=0;
  for(angle=0.f; angle<=2.f*float(M_PI); angle+=2.f*float(M_PI)/float(NSTEPS)) {
    std::string image = lr.rotate(angle);

    // Write the result to disk
    std::ofstream result((std::string("result") + boost::lexical_cast<std::string>(id++) + ".ppm").c_str());
    result << image;
    result.close();
  }

  return 0;
}
