package com.hello;

import android.os.Bundle;
import android.widget.TextView;
import android.widget.EditText;
import android.widget.Button;
import android.view.View;
import android.view.View.OnClickListener;
import com.calatrava.CalatravaPage;
import com.calatrava.bridge.RegisteredActivity;

@CalatravaPage(name = "helloForm")
public class HelloForm extends RegisteredActivity {

	private EditText eingabe;
	private TextView ausgabe;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.hello);

		eingabe = (EditText) findViewById(R.id.eingabe);
		ausgabe = (TextView) findViewById(R.id.ausgabe);

		Button fertig = (Button) findViewById(R.id.fertig);
		fertig.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				triggerEvent("fertig");
			}
		});
	}

	@Override
	protected String getPageName() {
		return "helloForm";
	}

	@Override
	public String getFieldValue(String field) {
		if ("eingabe".equals(field)) {
			return eingabe.getText().toString();
		}
		return null;
	}

	@Override
	public void render(String json) {
		final String s = json.replace("\"", "");
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				ausgabe.setText(s);
			}
		});
	}
}
