/*
 * canframe.cpp
 *
 *  Created on: 18.04.2013
 *      Author: mu
 */

#include "canframe.h"

/* --CAN-Frame ausgeben. */
void printCANFrame(const can_frame& frame, const timeval& tv, std::ostream& out) {

	/* --Bit 31 identifies the address type (0=standard, 11 bits; 1=extended, 29 bits). */
	uint32_t ident=(frame.can_id&(1<<31) ? frame.can_id&0x1fffffff : frame.can_id&0x7ff);
	/* --Bit 30 is rtr flag. */
	bool rtr=frame.can_id&(1<<30);
	/* --Bit 29 is error frame flag. */
	bool error=frame.can_id&(1<<29);

	/* --Save the flags. */
	std::ios::fmtflags flags=out.flags();

	/* --Write timestamp. */
	out << std::setfill('0') << std::setw(5) << tv.tv_sec << ':'
		<< std::right << std::setw(3) << tv.tv_usec/1000 << '.'
	    << std::setw(3) << tv.tv_usec%1000;

	/* --Write CAN frame header. */
	out << '|' << std::setfill(' ') << std::setw(8) << std::hex << ident << std::dec
		<< '|' << error
		<< '|' << rtr
		<< '|' << (uint32_t)frame.can_dlc << '|';

	/* --Write CAN frame payload. */
	for(uint32_t i=0;i<frame.can_dlc;i++)
		out << std::setfill('0') << std::hex << std::setw(2) << (uint32_t)frame.data[i] << ' ';
	for(uint32_t i=frame.can_dlc;i<8;i++)
		out << "__ ";

	out << '|';
	/* --Schreibe ASCII-Darstellung falls möglich. */
	for(uint32_t i=0;i<frame.can_dlc;i++)
		if (std::isprint(frame.data[i]))
			out << (char)frame.data[i];
		else
			out << '.';
	for(uint32_t i=frame.can_dlc;i<8;i++)
		out << '.';

	out << std::endl;

	/* --Restore the flags. */
	out.flags(flags);
}



