#!/bin/bash
# --Als root ausführen (sudo).

ISOTPPATH=/lib/modules/3.2.0-39-generic/kernel/net/can

# --Aufruf mit 'can' oder 'vcan'.
if [ "$1" != "can" -a "$1" != "vcan" ]
 then
  echo "Aufruf mit $0 {can|vcan} - Ende."
fi
 
# --Module in Kernel laden.
modprobe can
modprobe can_bcm
modprobe can_raw
modprobe "$1"

insmod $ISOTPPATH/can-isotp.ko

# --Konfiguration CAN-Schnittstelle.
if [ "$1" == "vcan" ]
 then
  ip link add dev vcan0 type vcan
fi

# --Starten der CAN-Schnittstelle
ip link set up "${1}0"



