﻿using System;
using System.Data.Entity.ModelConfiguration.Configuration.Properties.Primitive;
using System.Data.Entity.ModelConfiguration.Configuration.Types;
using System.Data.Entity.ModelConfiguration.Conventions;
using System.Linq;
using System.Reflection;

namespace de.WWWings.CodeOnly.Kontext
{

 /// <summary>
 /// Konvention 1: In der Datenbank erhalten alle Tabellennamen das Suffix "_Table"
 /// </summary>
 public class TableNameConvention : Convention
 {
  public TableNameConvention()
  {

   Types().Configure(c => c.ToTable(c.ClrType.Name + "_Table"));
  }
 }


 /// <summary>
 /// ALT: Alpha
 /// </summary>
 //public class TableNameConvention :
 // IConfigurationConvention<Type, EntityTypeConfiguration>
 //{
 // public void Apply(
 //  Type typeInfo,
 //  Func<EntityTypeConfiguration> configuration)
 // {
 //  configuration().ToTable(typeInfo.Name + "_Tab");
 // }
 //}

 /// <summary>
 /// Konvention 2: Alle Properties, die auf "Nr" enden, sind Primärschlüssel
 /// </summary>
 public class NrIsPKConvention : Convention
 {
  public NrIsPKConvention()
  {
     Properties()
     .Where(p => p.Name.EndsWith("Nr"))
     .Configure(p => p.IsKey());
  }
 }

 /// <summary>
 /// Alt: Alpha
 /// </summary>
 //public class NrIsPKConvention :
 // IConfigurationConvention<Type, EntityTypeConfiguration>
 //{
 // public void Apply(
 //  Type typeInfo,
 //  Func<EntityTypeConfiguration> configuration)
 // {

 //  // Jedes Property, das auf "Nr" endet, ist Teil des Primärschlüssels
 //  foreach (var propertyInfo in typeInfo.GetProperties().Where(p => p.Name.EndsWith("Nr")))
 //  {
 //   configuration().Key(propertyInfo);
 //  }
 // }
 //}


 /// <summary>
 /// Konvention 3: Für DateTime wird in der Datenbank nicht DateTime, sondern DateTime2 genutzt
 /// </summary>
 public class DateTimeColumnTypeConvention : Convention
 {
  public DateTimeColumnTypeConvention()
  {
   Properties<DateTime>()
              .Configure(c => c.HasColumnType("datetime2"));
  }
 }

 /// <summary>
 /// Alt: Alpha
 /// </summary>
 //public class DateTimeColumnTypeConvention :
 // IConfigurationConvention<PropertyInfo, DateTimePropertyConfiguration>
 //{
 // public void Apply(
 //  PropertyInfo propertyInfo,
 //  Func<DateTimePropertyConfiguration> configuration)
 // {
 //  configuration().ColumnType = "datetime2";
 // }
 //}
}


