namespace de.WWWings.CodeOnly.Migrations
{
    using System;
    using System.Data.Entity.Migrations;
    
    public partial class v1 : DbMigration
    {
        public override void Up()
        {
            CreateTable(
                "dbo.Flug",
                c => new
                    {
                        FlugNr = c.Int(nullable: false, identity: true),
                        Abflugort = c.String(maxLength: 50),
                        Zielort = c.String(maxLength: 50),
                        Datum = c.DateTime(nullable: false),
                        NichtRaucherFlug = c.Boolean(nullable: false),
                        Plaetze = c.Short(),
                        Preis = c.Decimal(nullable: false, precision: 18, scale: 2),
                        FreiePlaetze = c.Short(),
                        Ankunft = c.DateTime(),
                        PilotId = c.Int(nullable: false),
                        CopilotId = c.Int(nullable: false),
                    })
                .PrimaryKey(t => t.FlugNr)
                .ForeignKey("dbo.Pilot", t => t.CopilotId)
                .ForeignKey("dbo.Pilot", t => t.PilotId)
                .Index(t => t.CopilotId)
                .Index(t => t.PilotId);
            
            CreateTable(
                "dbo.Person",
                c => new
                    {
                        PersonID = c.Int(nullable: false, identity: true),
                        Name = c.String(),
                        Vorname = c.String(),
                        Geburtstag = c.DateTime(),
                        Strasse = c.String(),
                        Foto = c.Binary(),
                        EMail = c.String(),
                        Stadt = c.String(),
                        Land = c.String(),
                        Memo = c.String(),
                    })
                .PrimaryKey(t => t.PersonID);
            
            CreateTable(
                "dbo.PassagierFlug",
                c => new
                    {
                        Passagier_PersonID = c.Int(nullable: false),
                        Flug_FlugNr = c.Int(nullable: false),
                    })
                .PrimaryKey(t => new { t.Passagier_PersonID, t.Flug_FlugNr })
                .ForeignKey("dbo.Passagier", t => t.Passagier_PersonID, cascadeDelete: true)
                .ForeignKey("dbo.Flug", t => t.Flug_FlugNr, cascadeDelete: true)
                .Index(t => t.Passagier_PersonID)
                .Index(t => t.Flug_FlugNr);
            
            CreateTable(
                "dbo.Passagier",
                c => new
                    {
                        PersonID = c.Int(nullable: false),
                        KundeSeit = c.DateTime(),
                        KundenStatus = c.String(maxLength: 1),
                    })
                .PrimaryKey(t => t.PersonID)
                .ForeignKey("dbo.Person", t => t.PersonID)
                .Index(t => t.PersonID);
            
            CreateTable(
                "dbo.Pilot",
                c => new
                    {
                        PersonID = c.Int(nullable: false),
                        FlugscheinSeit = c.DateTime(nullable: false),
                        Flugstunden = c.Int(),
                        Flugscheintyp = c.String(),
                        Flugschule = c.String(),
                    })
                .PrimaryKey(t => t.PersonID)
                .ForeignKey("dbo.Person", t => t.PersonID)
                .Index(t => t.PersonID);
            
            CreateStoredProcedure(
                "dbo.Flug_Insert",
                p => new
                    {
                        Abflugort = p.String(maxLength: 50),
                        Zielort = p.String(maxLength: 50),
                        Datum = p.DateTime(),
                        NichtRaucherFlug = p.Boolean(),
                        Plaetze = p.Short(),
                        Preis = p.Decimal(precision: 18, scale: 2),
                        FreiePlaetze = p.Short(),
                        Ankunft = p.DateTime(),
                        PilotId = p.Int(),
                        CopilotId = p.Int(),
                    },
                body:
                    @"INSERT [dbo].[Flug]([Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [Preis], [FreiePlaetze], [Ankunft], [PilotId], [CopilotId])
                      VALUES (@Abflugort, @Zielort, @Datum, @NichtRaucherFlug, @Plaetze, @Preis, @FreiePlaetze, @Ankunft, @PilotId, @CopilotId)
                      
                      DECLARE @FlugNr int
                      SELECT @FlugNr = [FlugNr]
                      FROM [dbo].[Flug]
                      WHERE @@ROWCOUNT > 0 AND [FlugNr] = scope_identity()
                      
                      SELECT t0.[FlugNr]
                      FROM [dbo].[Flug] AS t0
                      WHERE @@ROWCOUNT > 0 AND t0.[FlugNr] = @FlugNr"
            );
            
            CreateStoredProcedure(
                "dbo.Flug_Update",
                p => new
                    {
                        FlugNr = p.Int(),
                        Abflugort = p.String(maxLength: 50),
                        Zielort = p.String(maxLength: 50),
                        Datum = p.DateTime(),
                        NichtRaucherFlug = p.Boolean(),
                        Plaetze = p.Short(),
                        Preis = p.Decimal(precision: 18, scale: 2),
                        FreiePlaetze = p.Short(),
                        Ankunft = p.DateTime(),
                        PilotId = p.Int(),
                        CopilotId = p.Int(),
                    },
                body:
                    @"UPDATE [dbo].[Flug]
                      SET [Abflugort] = @Abflugort, [Zielort] = @Zielort, [Datum] = @Datum, [NichtRaucherFlug] = @NichtRaucherFlug, [Plaetze] = @Plaetze, [Preis] = @Preis, [FreiePlaetze] = @FreiePlaetze, [Ankunft] = @Ankunft, [PilotId] = @PilotId, [CopilotId] = @CopilotId
                      WHERE ([FlugNr] = @FlugNr)"
            );
            
            CreateStoredProcedure(
                "dbo.Flug_Delete",
                p => new
                    {
                        FlugNr = p.Int(),
                    },
                body:
                    @"DELETE [dbo].[Flug]
                      WHERE ([FlugNr] = @FlugNr)"
            );
            
            CreateStoredProcedure(
                "dbo.Pilot_Insert",
                p => new
                    {
                        Name = p.String(),
                        Vorname = p.String(),
                        Geburtstag = p.DateTime(),
                        Strasse = p.String(),
                        Foto = p.Binary(),
                        EMail = p.String(),
                        Stadt = p.String(),
                        Land = p.String(),
                        Memo = p.String(),
                        FlugscheinSeit = p.DateTime(),
                        Flugstunden = p.Int(),
                        Flugscheintyp = p.String(),
                        Flugschule = p.String(),
                    },
                body:
                    @"INSERT [dbo].[Person]([Name], [Vorname], [Geburtstag], [Strasse], [Foto], [EMail], [Stadt], [Land], [Memo])
                      VALUES (@Name, @Vorname, @Geburtstag, @Strasse, @Foto, @EMail, @Stadt, @Land, @Memo)
                      
                      DECLARE @PersonID int
                      SELECT @PersonID = [PersonID]
                      FROM [dbo].[Person]
                      WHERE @@ROWCOUNT > 0 AND [PersonID] = scope_identity()
                      
                      INSERT [dbo].[Pilot]([PersonID], [FlugscheinSeit], [Flugstunden], [Flugscheintyp], [Flugschule])
                      VALUES (@PersonID, @FlugscheinSeit, @Flugstunden, @Flugscheintyp, @Flugschule)
                      
                      SELECT t0.[PersonID]
                      FROM [dbo].[Person] AS t0
                      WHERE @@ROWCOUNT > 0 AND t0.[PersonID] = @PersonID"
            );
            
            CreateStoredProcedure(
                "dbo.Pilot_Update",
                p => new
                    {
                        PersonID = p.Int(),
                        Name = p.String(),
                        Vorname = p.String(),
                        Geburtstag = p.DateTime(),
                        Strasse = p.String(),
                        Foto = p.Binary(),
                        EMail = p.String(),
                        Stadt = p.String(),
                        Land = p.String(),
                        Memo = p.String(),
                        FlugscheinSeit = p.DateTime(),
                        Flugstunden = p.Int(),
                        Flugscheintyp = p.String(),
                        Flugschule = p.String(),
                    },
                body:
                    @"UPDATE [dbo].[Person]
                      SET [Name] = @Name, [Vorname] = @Vorname, [Geburtstag] = @Geburtstag, [Strasse] = @Strasse, [Foto] = @Foto, [EMail] = @EMail, [Stadt] = @Stadt, [Land] = @Land, [Memo] = @Memo
                      WHERE ([PersonID] = @PersonID)
                      
                      UPDATE [dbo].[Pilot]
                      SET [FlugscheinSeit] = @FlugscheinSeit, [Flugstunden] = @Flugstunden, [Flugscheintyp] = @Flugscheintyp, [Flugschule] = @Flugschule
                      WHERE ([PersonID] = @PersonID)
                      AND @@ROWCOUNT > 0"
            );
            
            CreateStoredProcedure(
                "dbo.Pilot_Delete",
                p => new
                    {
                        PersonID = p.Int(),
                    },
                body:
                    @"DELETE [dbo].[Pilot]
                      WHERE ([PersonID] = @PersonID)
                      
                      DELETE [dbo].[Person]
                      WHERE ([PersonID] = @PersonID)
                      AND @@ROWCOUNT > 0"
            );
            
            CreateStoredProcedure(
                "dbo.Passagier_Insert",
                p => new
                    {
                        Name = p.String(),
                        Vorname = p.String(),
                        Geburtstag = p.DateTime(),
                        Strasse = p.String(),
                        Foto = p.Binary(),
                        EMail = p.String(),
                        Stadt = p.String(),
                        Land = p.String(),
                        Memo = p.String(),
                        KundeSeit = p.DateTime(),
                        KundenStatus = p.String(maxLength: 1),
                    },
                body:
                    @"INSERT [dbo].[Person]([Name], [Vorname], [Geburtstag], [Strasse], [Foto], [EMail], [Stadt], [Land], [Memo])
                      VALUES (@Name, @Vorname, @Geburtstag, @Strasse, @Foto, @EMail, @Stadt, @Land, @Memo)
                      
                      DECLARE @PersonID int
                      SELECT @PersonID = [PersonID]
                      FROM [dbo].[Person]
                      WHERE @@ROWCOUNT > 0 AND [PersonID] = scope_identity()
                      
                      INSERT [dbo].[Passagier]([PersonID], [KundeSeit], [KundenStatus])
                      VALUES (@PersonID, @KundeSeit, @KundenStatus)
                      
                      SELECT t0.[PersonID]
                      FROM [dbo].[Person] AS t0
                      WHERE @@ROWCOUNT > 0 AND t0.[PersonID] = @PersonID"
            );
            
            CreateStoredProcedure(
                "dbo.Passagier_Update",
                p => new
                    {
                        PersonID = p.Int(),
                        Name = p.String(),
                        Vorname = p.String(),
                        Geburtstag = p.DateTime(),
                        Strasse = p.String(),
                        Foto = p.Binary(),
                        EMail = p.String(),
                        Stadt = p.String(),
                        Land = p.String(),
                        Memo = p.String(),
                        KundeSeit = p.DateTime(),
                        KundenStatus = p.String(maxLength: 1),
                    },
                body:
                    @"UPDATE [dbo].[Passagier]
                      SET [KundeSeit] = @KundeSeit, [KundenStatus] = @KundenStatus
                      WHERE ([PersonID] = @PersonID)
                      
                      UPDATE [dbo].[Person]
                      SET [Name] = @Name, [Vorname] = @Vorname, [Geburtstag] = @Geburtstag, [Strasse] = @Strasse, [Foto] = @Foto, [EMail] = @EMail, [Stadt] = @Stadt, [Land] = @Land, [Memo] = @Memo
                      WHERE ([PersonID] = @PersonID)
                      AND @@ROWCOUNT > 0"
            );
            
            CreateStoredProcedure(
                "dbo.Passagier_Delete",
                p => new
                    {
                        PersonID = p.Int(),
                    },
                body:
                    @"DELETE [dbo].[Passagier]
                      WHERE ([PersonID] = @PersonID)
                      
                      DELETE [dbo].[Person]
                      WHERE ([PersonID] = @PersonID)
                      AND @@ROWCOUNT > 0"
            );
            
            CreateStoredProcedure(
                "dbo.Person_Insert",
                p => new
                    {
                        Name = p.String(),
                        Vorname = p.String(),
                        Geburtstag = p.DateTime(),
                        Strasse = p.String(),
                        Foto = p.Binary(),
                        EMail = p.String(),
                        Stadt = p.String(),
                        Land = p.String(),
                        Memo = p.String(),
                    },
                body:
                    @"INSERT [dbo].[Person]([Name], [Vorname], [Geburtstag], [Strasse], [Foto], [EMail], [Stadt], [Land], [Memo])
                      VALUES (@Name, @Vorname, @Geburtstag, @Strasse, @Foto, @EMail, @Stadt, @Land, @Memo)
                      
                      DECLARE @PersonID int
                      SELECT @PersonID = [PersonID]
                      FROM [dbo].[Person]
                      WHERE @@ROWCOUNT > 0 AND [PersonID] = scope_identity()
                      
                      SELECT t0.[PersonID]
                      FROM [dbo].[Person] AS t0
                      WHERE @@ROWCOUNT > 0 AND t0.[PersonID] = @PersonID"
            );
            
            CreateStoredProcedure(
                "dbo.Person_Update",
                p => new
                    {
                        PersonID = p.Int(),
                        Name = p.String(),
                        Vorname = p.String(),
                        Geburtstag = p.DateTime(),
                        Strasse = p.String(),
                        Foto = p.Binary(),
                        EMail = p.String(),
                        Stadt = p.String(),
                        Land = p.String(),
                        Memo = p.String(),
                    },
                body:
                    @"UPDATE [dbo].[Person]
                      SET [Name] = @Name, [Vorname] = @Vorname, [Geburtstag] = @Geburtstag, [Strasse] = @Strasse, [Foto] = @Foto, [EMail] = @EMail, [Stadt] = @Stadt, [Land] = @Land, [Memo] = @Memo
                      WHERE ([PersonID] = @PersonID)"
            );
            
            CreateStoredProcedure(
                "dbo.Person_Delete",
                p => new
                    {
                        PersonID = p.Int(),
                    },
                body:
                    @"DELETE [dbo].[Person]
                      WHERE ([PersonID] = @PersonID)"
            );
            
        }
        
        public override void Down()
        {
            DropStoredProcedure("dbo.Person_Delete");
            DropStoredProcedure("dbo.Person_Update");
            DropStoredProcedure("dbo.Person_Insert");
            DropStoredProcedure("dbo.Passagier_Delete");
            DropStoredProcedure("dbo.Passagier_Update");
            DropStoredProcedure("dbo.Passagier_Insert");
            DropStoredProcedure("dbo.Pilot_Delete");
            DropStoredProcedure("dbo.Pilot_Update");
            DropStoredProcedure("dbo.Pilot_Insert");
            DropStoredProcedure("dbo.Flug_Delete");
            DropStoredProcedure("dbo.Flug_Update");
            DropStoredProcedure("dbo.Flug_Insert");
            DropForeignKey("dbo.Pilot", "PersonID", "dbo.Person");
            DropForeignKey("dbo.Passagier", "PersonID", "dbo.Person");
            DropForeignKey("dbo.PassagierFlug", "Flug_FlugNr", "dbo.Flug");
            DropForeignKey("dbo.PassagierFlug", "Passagier_PersonID", "dbo.Passagier");
            DropForeignKey("dbo.Flug", "PilotId", "dbo.Pilot");
            DropForeignKey("dbo.Flug", "CopilotId", "dbo.Pilot");
            DropIndex("dbo.Pilot", new[] { "PersonID" });
            DropIndex("dbo.Passagier", new[] { "PersonID" });
            DropIndex("dbo.PassagierFlug", new[] { "Flug_FlugNr" });
            DropIndex("dbo.PassagierFlug", new[] { "Passagier_PersonID" });
            DropIndex("dbo.Flug", new[] { "PilotId" });
            DropIndex("dbo.Flug", new[] { "CopilotId" });
            DropTable("dbo.Pilot");
            DropTable("dbo.Passagier");
            DropTable("dbo.PassagierFlug");
            DropTable("dbo.Person");
            DropTable("dbo.Flug");
        }
    }
}
