﻿using EFModell;
using ITVisions;
using System;
using System.Collections.Generic;
using System.Data.Entity.Core.Metadata.Edm;
using System.Data.Entity.Infrastructure;
using System.Data.Entity.ModelConfiguration.Conventions;
using System.Linq;

namespace de.WWWings.CodeOnly.Kontext
{

 /// <summary>
 /// Legt fest, dass decimalspalten im Standard nicht als decimal(18, 0), sondern decimal(8, 2) gespeichert werden. 
 /// </summary>
 class DecimalPrecisionAndScaleConvention : IStoreModelConvention<EdmProperty>
 {
  public void Apply(EdmProperty property, DbModel model)
  {
   if (property.PrimitiveType.PrimitiveTypeKind == PrimitiveTypeKind.Decimal)
   {
    property.Precision = 8;
    property.Scale = 4;
   }
  }
 }


 /// <summary>
 /// Alt: Alpha
 /// </summary>
 //class DecimalPrecisionAndScaleConvention : IEdmConvention<EdmProperty>
 //{
 // public void Apply(EdmProperty property, EdmModel model)
 // {
 //  if (property.PrimitiveType.PrimitiveTypeKind == PrimitiveTypeKind.Decimal)
 //  {
 //   property.Precision = 8;
 //   property.Scale = 4;
 //  }
 // }
 //}


 /// <summary>
 /// Legt im Standard ConcurrencyMode.Fixed fest, außer bei mit [ConcurrencyNoCheckAttribute] annotierten Properties
 /// </summary>
 class ConcurrencyFixedConvention : IConceptualModelConvention<EdmProperty>
 {

  public void Apply(EdmProperty property, DbModel model)
  {
   var annotationen = property.MetadataProperties.Where(a => a.Name == "ClrAttributes").FirstOrDefault();
   if (annotationen != null && annotationen.Value != null)
   {
    List<System.Attribute> attributliste = annotationen.Value as List<System.Attribute>;
    var an = attributliste.OfType<ConcurrencyNoCheckAttribute>();
    if (an.Count() > 0)
    {
     property.ConcurrencyMode = ConcurrencyMode.None;
     CUI.Print(property.Name + ": ConcurrencyMode.None", ConsoleColor.Yellow);
    }
    else
    {
     if (property.DeclaringType.BaseType == null)
     {
      CUI.Print(property.Name + ": ConcurrencyMode.Fixed", ConsoleColor.Green);
      property.ConcurrencyMode = ConcurrencyMode.Fixed;
     }
   }
 
   }
   // Console.WriteLine(property.DeclaringType + "." + property.Name + ": " + property.ConcurrencyMode);
  }
 }

 /// <summary>
 /// alt: Alpha
 /// </summary>
 //class ConcurrencyFixedConvention : IEdmConvention<EdmProperty>
 //{
 // public void Apply(EdmProperty property, EdmModel model)
 // {
 //  var annotationen = property.Annotations.Where(a => a.Name == "ClrAttributes").FirstOrDefault();
 //  if (annotationen != null && annotationen.Value != null)
 //  {
 //   List<System.Attribute> attributliste = annotationen.Value as List<System.Attribute>;
 //   var an = attributliste.OfType<ConcurrencyNoCheckAttribute>();
 //   if (an.Count() > 0)
 //   {
 //    property.ConcurrencyMode = ConcurrencyMode.None;
 //   }
 //   else
 //   {
 //    if (property.DeclaringType.BaseType == null)
 //    {
 //     property.ConcurrencyMode = ConcurrencyMode.Fixed;
 //    }
 //   }
 //  }
 // // Console.WriteLine(property.DeclaringType + "." + property.Name + ": " + property.ConcurrencyMode);
 // }
 //}
}
