

using EFModell;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace de.WWWings.CodeOnly
{


 public partial class Flug
 {
  // --- Primrschlssel

  [Key]
  public int FlugNr { get; set; }

  // --- Weitere Eigenschaften
  [StringLength(50), MinLength(3)]
  public string Abflugort { get; set; }
  [StringLength(50), MinLength(3)]
  public string Zielort { get; set; }

  //[Column("FlugDatum", Order = 2)]
  [DBDate]
  public System.DateTime Datum { get; set; }

  public bool NichtRaucherFlug { get; set; }

  //[ConcurrencyCheckAttribute]
  [Range(100, 250)]
  public Nullable<short> Plaetze { get; set; }

  [ConcurrencyNoCheck]
  public decimal Preis
  {
   get;
   set;
  }

  //[Required]
  //[ConcurrencyCheckAttribute]
  public Nullable<System.Int16> FreiePlaetze
  {
   get;
   set;
  }

  [ConcurrencyNoCheck]
  public Nullable<System.DateTime> Ankunft
  {
   get;
   set;
  }

  //public bool Bestreikt
  //{
  // get;
  // set;
  //}

  [NotMapped]
  public string Memo
  {
   get;
   set;
  }

  // --- Beziehungen zu anderen Entitten
  public virtual ICollection<Passagier> Passagiere { get; set; }
  [ForeignKey("PilotId")]
  public virtual Pilot Pilot { get; set; }
  [ForeignKey("CopilotId")]
  public virtual Pilot Copilot { get; set; }


  public int PilotId { get; set; }
  public int CopilotId { get; set; }
  //public int PilotFK
  //{
  // get;
  // set;
  //}
  //public bool Test2 { get; set; }
  //[ConcurrencyCheckAttribute]

  //public bool SkyMarshalOnBoard { get; set; }

 }
}