﻿using ITVisions;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// (C) www.IT-Visions.de - Dr. Holger Schwichtenberg

namespace EFDBContextDemos.Verbesserungen_DbContext
{
public static class EF_Util
 {

 /// <summary>
 /// Ausgabe aller geänderten Objekte und die geänderten Properties
 /// </summary>
 /// <param name="ctx"></param>
 public static void PrintChangeInfo(DbContext ctx)
 {
 
  foreach (DbEntityEntry entry in ctx.ChangeTracker.Entries())
   {
    if (entry.State == EntityState.Modified)
    {
     CUI.Print(entry.Entity.ToString() + " ist im Zustand " + entry.State, ConsoleColor.Yellow);
     foreach (string propertyName in entry.OriginalValues.PropertyNames)
     {
      if (!object.Equals(entry.OriginalValues.GetValue<object>(propertyName), 
       entry.CurrentValues.GetValue<object>(propertyName)))
      {
       Console.WriteLine(propertyName + ": " + 
        entry.OriginalValues.GetValue<object>(propertyName) + "->" + 
        entry.CurrentValues.GetValue<object>(propertyName));
      }
     }
    }
   }
 }

 }
}
