﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// (C) www.IT-Visions.de - Dr. Holger Schwichtenberg

namespace de.WWWings.GO.Validierungsannotationen
{
 /// <summary>
 /// Eigene Validierungsklasse
 /// Fester regulärer Ausdruck für Flughafenname
 /// </summary>
 [AttributeUsage(AttributeTargets.Field | AttributeTargets.Property, AllowMultiple = false)]
 public class FlughafenNameAttribute : ValidationAttribute
 {
  const string pattern = "^[A-Z][a-z]+[-/]?[A-Z]{0,1}[a-z]*$";

  public FlughafenNameAttribute(string ErrorMessage)
   : base(ErrorMessage)
  {

  }
  public override bool IsValid(object value)
  {
   string Eingabe = value.ToString();
   if (String.IsNullOrWhiteSpace(Eingabe)) return false;
   var regEx = new System.Text.RegularExpressions.Regex(pattern);
   return regEx.Match(Eingabe).Success;
  }
 }

 /// <summary>
 /// Eigene Validierungsklasse
 /// Auswahl muss aus einer vorgegebene Menge von Zeichenketten kommen
 /// </summary>
 [AttributeUsage(AttributeTargets.Field | AttributeTargets.Property, AllowMultiple = false)]
 public class ChoiceAttribute : ValidationAttribute
 {

  public List<string> Choices { get; set; }
  public ChoiceAttribute(params string[] choices)
  {
   this.Choices = choices.ToList();
  }
  public override bool IsValid(object value)
  {
   if (value == null) return false;
   return (Choices.Contains(value.ToString()));
  }
 }
}
