//
//  GameCenterVerwaltung.h
//  GCGame
//

#import <Foundation/Foundation.h>
#import <GameKit/GKMatch.h>
#import <GameKit/GKLeaderboard.h>
#import <GameKit/GameKit.h>
#import <GameKit/GKTurnBasedMatchmakerViewController.h>

@interface GameCenterVerwaltung : NSObject <GKTurnBasedMatchmakerViewControllerDelegate ,GKMatchDelegate, GKTurnBasedEventHandlerDelegate, GKLocalPlayerListener> 

- (void)        authenticateLocalPlayer;
- (void)        setupMultiplayerGame;
- (void)        loadPlayerData:(NSArray *)theFriendIDs;
- (void)        advanceMatch;
- (GKTurnBasedParticipant *) getOpponentParticipiant;

@property (nonatomic, strong)   GKLocalPlayer* mAuthenticatedPlayer;
@property (nonatomic, strong)   UIViewController* mGameControllerVC;
@property (nonatomic, strong)   GKTurnBasedMatch* mUnserSpiel;
@property (nonatomic, strong)   NSNumber*         mActualTurnValue;

@end
