//
//  GameCenterVerwaltung.m
//  GCGame
//

#import "GameCenterVerwaltung.h"
#import "GameViewController.h"

@implementation GameCenterVerwaltung{
    int mRounds;
    GKTurnBasedMatchmakerViewController *mmvc;
    NSMutableData* mOurGameData;
}

- (id) init {
    self = [super init];
    if(self!= NULL)     {

    }
    return self;
}

/**
 * GameCenter Dialog wurde abgebrochen. Popup wieder entfernen. #check
 */
- (void)turnBasedMatchmakerViewControllerWasCancelled:(GKTurnBasedMatchmakerViewController *)viewControlle{
    [self.mGameControllerVC dismissViewControllerAnimated:YES completion:nil];
}

//
- (void)checkLocalPlayer{
    GKLocalPlayer *localPlayer = [GKLocalPlayer localPlayer];
    
    if (localPlayer.isAuthenticated)
    {
        /* Ggf. weitere EINrichtung um den Spieler zu konfigurieren, kann hier erfolgen */
        NSLog(@"Jetzt kann es losgehen.");
        self.mAuthenticatedPlayer = localPlayer;
        [self.mAuthenticatedPlayer registerListener:self];   // Hierdurch weisen wir den Listener zu den Delegatefunktionen Events zu
        
    }
    else
    {
        /* Für den Fall, dass der Spieler nicht authentifiziert wurde */
    }
}

// Unseren Spieler anmelden
- (void)authenticateLocalPlayer{
    GKLocalPlayer *localPlayer = [GKLocalPlayer localPlayer];
    
    // Implementierung ab iOS 6.0
    [localPlayer setAuthenticateHandler:(^(UIViewController* viewcontroller, NSError *error) {
        if (!error && viewcontroller)
        {
            [self.mGameControllerVC presentViewController:viewcontroller animated:YES completion:nil];
        }
        else
        {
            [self checkLocalPlayer];
        }
    })];
}

/**
 * GameKit ViewController wurde beendet - wir können das Ergebnis abfragen und ggf. verwenden. #check
 */
- (void)gameCenterViewControllerDidFinish:(GKGameCenterViewController *)gameCenterViewController{
    [self.mGameControllerVC dismissViewControllerAnimated:YES completion:nil];
}

/**
 *  Spiel Handshake hat funktioniert #check
 */
- (void)turnBasedMatchmakerViewController:(GKTurnBasedMatchmakerViewController *)viewController didFindMatch:(GKTurnBasedMatch *)match{
    [self.mGameControllerVC dismissViewControllerAnimated:YES completion:nil];
    // In den Spielescreen wechseln um zu spielen.
    // Hier kann dann ggf. ein eigenen Screen angezeigt werden oder eine Segue im Storyboard ausgelöst werden.
    self.mUnserSpiel = match;

    
    // Ohne einen Aufruf, dass die Runde endet und an den anderen Spieler übergeben wird, wird beim Mitspieler noch kein Game Center Event ausgelöst.
    
    // Nach diesem Aufruf ist der Gegner an der Reihe. Die per MatchData übergebenen Daten müssen im jeweiligen Spiel lokal ausgewertet werden.
}

/**
 * Spieler hat das Spiel verlassen
 */
- (void)turnBasedMatchmakerViewController:(GKTurnBasedMatchmakerViewController *)viewController playerQuitForMatch:(GKTurnBasedMatch *)match{
    NSLog(@"Ein Spieler hat das Spiel verlassen.");
    // Hier können wir ggf. in unserer GUI drauf reagieren und dies ausgeben.
}


/**
 * Es ist ein Fehler aufgetreten. Diesen können wir über NSError auswerten und ggf. behandeln.
 */
- (void) turnBasedMatchmakerViewController:(GKTurnBasedMatchmakerViewController *)viewController didFailWithError:(NSError *)error{
    // Im View
    NSLog(@"Es ist ein Fehler im MatchMaker aufgetreten: %@",error.userInfo);
}

/**
 *
 */
- (void) player:(GKPlayer *)player didRequestMatchWithPlayers:(NSArray *)playerIDsToInvite{
    // Kann ggf. individuell ausimplementiert werden.
}

/**
 * Nimmt den Spielzug aus GameCenter entgegen. Dieser Event wird auch gestartet, wenn die App z.B. im Hintergrund ist und über GameCenter im NotificationCenter das Spiel angenommen wird. Der Parameter Match repräsentiert hierbei das bestätigte Spiel.
 */
- (void)player:(GKPlayer *)player receivedTurnEventForMatch:(GKTurnBasedMatch *)match didBecomeActive:(BOOL)didBecomeActive{
    self.mUnserSpiel = match;
    mOurGameData = [NSMutableData dataWithData:match.matchData];
    
    if(didBecomeActive == TRUE){
        // laden den aktuellen Datenbestand aus GameCenter für unsere Partie
        [self.mUnserSpiel loadMatchDataWithCompletionHandler:^(NSData *matchData, NSError *error) {
            if (matchData)
            {
                // App-specific routine to decode the match data.
                mOurGameData = [NSMutableData dataWithData:matchData];
                
                CGFloat z;
                [matchData getBytes:&z length:sizeof(matchData.length)];
                _mActualTurnValue = [NSNumber numberWithFloat:z];
                
                if([[self mGameControllerVC] respondsToSelector:@selector(updateGameData)]){
                    [[self mGameControllerVC] performSelector:@selector(updateGameData) withObject:_mActualTurnValue];
                }
            }
            GameViewController *vc = (GameViewController *)self.mGameControllerVC;
            vc.mLabelStatus.text = @"Status: Wir sind wieder an der Reihe.";
        }];
    }
    else
        NSLog(@"Inaktiv - passed to another player");
}

#pragma mark Listerner Funktionen GameCenter
- (void) player:(GKPlayer *)player receivedExchangeRequest:(GKTurnBasedExchange *)exchange forMatch:(GKTurnBasedMatch *)match{
    // Um während einer Runde Daten auszutauschen.
    // MatchData kann hier emfpangen und ggf. interpretiert werden
}

- (void) player:(GKPlayer *)player receivedExchangeCancellation:(GKTurnBasedExchange *)exchange forMatch:(GKTurnBasedMatch *)match{
    // Je nach Spielanforderung ggf. implementieren.
}

- (void) player:(GKPlayer *)player receivedExchangeReplies:(NSArray *)replies forCompletedExchange:(GKTurnBasedExchange *)exchange forMatch:(GKTurnBasedMatch *)match{
    // Je nach Spielanforderung interpretieren.
}

- (void) player:(GKPlayer *)player matchEnded:(GKTurnBasedMatch *)match{
    // Das Spiel ist beendet
    GameViewController *vc = (GameViewController *)self.mGameControllerVC;
    vc.mLabelStatus.text = @"Status: Das Spiel wurde beendet.";
}


/**
 * Der Gegner hat unsere Einladung angenommen und wir können das Spiel beginnen.
 */
- (void) player:(GKPlayer *)player didAcceptInvite:(GKInvite *)invite{
    // Der Gegner hat das Spiel angenommen und wir können starten. Mit diesem Callback können wir die lokale Darstellung ggf. anpassen, Bedienelemente aktivieren / ausblenden.
}

/**
 * Für dem Fall, dass wir Challenges verwenden möchten
 */
-(void) player:(GKPlayer *)player didReceiveChallenge:(GKChallenge *)challenge{
    // Wenn Challenges in einem Spiel verwendet werden, können diese hier entgegen genommen werden.
}


/**
 * Richtet ein Multispieler Game ein und setzt es im Erfolgsfalls über GameCenter ab
 */
- (void) setupMultiplayerGame{
    // Wir definieren unsere Spielanfrage
    NSLog(@"Spiel einrichten");
    GKMatchRequest* request = [[GKMatchRequest alloc] init];
    request.minPlayers = 2;
    request.maxPlayers = 2;
    request.defaultNumberOfPlayers = 2;
    
    // Spiel ist definiert, wir lösen nun den Game Center ViewController aus, um ein Gegner zu unserem Spiel einzuladen.
    mmvc = [[GKTurnBasedMatchmakerViewController alloc] initWithMatchRequest:request];
    mmvc.turnBasedMatchmakerDelegate = self;
    [self.mGameControllerVC presentViewController:mmvc animated:YES completion:nil];
}

/**
 * Die Daten der Spieler auslesen
 */
- (void) loadPlayerData: (NSArray *) identifiers{
    [GKPlayer loadPlayersForIdentifiers:identifiers withCompletionHandler:^(NSArray *players, NSError *error) {
        if (error != nil)
        {
            NSLog(@"Es ist ein Fehler aufgetreten.");
        }
        if (players != nil)
        {
            // Wir können nun das Player Array parsen und ggf. individuell ausarbeiten. Je nachdem wie wir unser Spiel ausprägen.
        }
    }];
}

/**
 * eine Runde auslösen
 */
- (void) advanceMatch{
    
    float z = _mActualTurnValue.floatValue;
    if(mOurGameData == nil){
        mOurGameData = [NSMutableData dataWithCapacity:0];
        [mOurGameData appendBytes:&z length:sizeof(float)];
    }
    else{
        [mOurGameData appendBytes:&z length:sizeof(float)];
    }

    // Speichert den Spielstand in unserer Spielrunde.
    [self.mUnserSpiel saveCurrentTurnWithMatchData:[NSData dataWithData:mOurGameData] completionHandler:^(NSError *error) {
        if(!error){
            [self.mUnserSpiel endTurnWithNextParticipants:[NSArray arrayWithObjects:[self getOpponentParticipiant], nil] turnTimeout:GKTurnTimeoutDefault matchData:[NSData dataWithData:mOurGameData] completionHandler:^(NSError *error){
                if(!error){
                    NSLog(@"Der andere Spieler ist nun dran.");
                    GameViewController *vc = (GameViewController *)self.mGameControllerVC;
                    vc.mLabelStatus.text = @"Status: Der Gegner ist nun an der Reihe";
                }
                else{
                    NSLog(@"Es ist ein Feher aufgetreten %@",error.description);
                    GameViewController *vc = (GameViewController *)self.mGameControllerVC;
                    vc.mLabelStatus.text = @"Status: Es ist ein Fehler aufgetreten";
                }
            }];
        }
        else{
            NSLog(@"Fehler %@",error.description);
        }
    }];
}

/**
 * In unserem Spiel haben wir nur eine Liste des lokalen Spielsers sowie der potentiellen Gegner. Wir wissen aber nicht, wer der nächste ist. Dies gehört zur Spiellogik und muss von uns ermittelt werden. Da wir nur zwei Gegner haben, ermitteln wir einfach den jeweiligen Spieler anhand des Index.
 * GameKit sieht vor, dass die Reihenfolge in dem Array dem der Spielreihenfolge entspricht - dies können wir voraussetzen - die Prüfung dient der Sicherheit.
 */
- (GKTurnBasedParticipant *) getOpponentParticipiant{
    for(GKTurnBasedParticipant* gegner in self.mUnserSpiel.participants){
        if(!([gegner.playerID isEqualToString:self.mAuthenticatedPlayer.playerID])){
            return gegner;
        }
    }
    return nil;
}

#pragma mark match Protokoll Implementierungen
- (void)match:(GKMatch *)match didFailWithError:(NSError *)error{
    NSLog(@"Es ist ein Fehler aufgetreten");
}

- (void) match:(GKMatch *)match didReceiveData:(NSData *)data fromPlayer:(NSString *)playerID{

}

- (void)handleInviteFromGameCenter:(NSArray *)playersToInvite{
    NSLog(@"Diese Funktion ist Deprecated in iOS 7");
}

-(void) handleTurnEventForMatch:(GKTurnBasedMatch *)match didBecomeActive:(BOOL)didBecomeActive{
    NSLog(@"Deprecated in iOS7");
}



@end
