//
//  ViewController.m
//  GCGame
//

#import "GameViewController.h"

@interface GameViewController (

)

@end

@implementation GameViewController{
    NSNumber* mTriesLeft;   // Drei Versuche pro Runde
    NSNumber* mRunden;      // Die aktuellen Runden
    NSNumberFormatter* mNumberFormatter;  // NumberFormatter um unser Ergebnis zu formatieren
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Spiel einrichten
    [self resetSpiel:nil];
    mNumberFormatter = [[NSNumberFormatter alloc] init];
}

- (void) viewDidAppear:(BOOL)animated{
    [super viewDidAppear:animated];

    self.mGCManager = [[GameCenterVerwaltung alloc] init];
    [self.mGCManager setMGameControllerVC:self];

    [self showGameCenter];
}

- (void)didReceiveMemoryWarning{
    [super didReceiveMemoryWarning];
    // Unnötigen Speicher ggf. freigeben
    
}

/**
 * GameKit ViewController anzeigen um ein Spiel auszulösen. Wir triggern aus unserer View unseren GameController, die die Protokolle und Delegates implementiert.
 */
- (void) showGameCenter{
    [self.mGCManager authenticateLocalPlayer];
}

/**
 * Diese Funktion ermöglicht es, entsprechende Nachrichten bei Ereignissen als GameCenter Banner in die App laufen zu lassen
 */
- (void) showBanner{
    NSString* title = [self generateTitle];
    NSString* message = [self generateBannerMessage];
    [GKNotificationBanner showBannerWithTitle: title message: message
                            completionHandler:^{
                                // Ggf. Individuelle Aktion auslösen
                                NSLog(@"Banner wurde angezeigt");
                            }];
}

- (NSString *) generateTitle{
    return @"Bannertitel";
}

- (NSString *) generateBannerMessage{
    return @"Unsere Nachricht";
}

#pragma mark Spiel Basisfuntkionen
/**
 *
 */
- (IBAction) wuerfeln:(id)sender{
    // Zielarray für unser Ergebnis
    NSMutableArray* arrResults = [NSMutableArray arrayWithCapacity:3];

    // Erzeugt unsere 3 Zufallszahlen
    [arrResults addObject:[NSNumber numberWithInt:(((arc4random() % 9) + 1))]];
    [arrResults addObject:[NSNumber numberWithInt:(((arc4random() % 9) + 1))]];
    [arrResults addObject:[NSNumber numberWithInt:(((arc4random() % 9) + 1))]];
    
    // Sortiert das Ergebnis als Hohe Straße
    arrResults = [NSMutableArray arrayWithArray:[arrResults sortedArrayUsingSelector:@selector(compare:)]];
    
    // Zeigt das gewürfelte Ergebnis an
    if(self.mBtn1.enabled)
    [self.mBtn1 setTitle:[NSString stringWithFormat:@"%d",[[arrResults objectAtIndex:2] intValue]] forState:UIControlStateNormal];
    if(self.mBtn2.enabled)
        [self.mBtn2 setTitle:[NSString stringWithFormat:@"%d",[[arrResults objectAtIndex:1] intValue] ] forState:UIControlStateNormal];
    if(self.mBtn3.enabled)
        [self.mBtn3 setTitle:[NSString stringWithFormat:@"%d",[[arrResults objectAtIndex:0] intValue] ] forState:UIControlStateNormal];


    
    // Decrment der Versuche pro Runde.
    mTriesLeft = [NSNumber numberWithInt:(mTriesLeft.intValue - 1)];
    
    [self anzeigeAktualisieren];
}

/**
 * Unsere Würfelbuttons einrasten oder freigeben
 */
- (IBAction) toggleButton:(id)sender{
    UIButton* theBtn = (UIButton *)sender;
    if(theBtn.enabled){
        theBtn.enabled = false;
    }
}


/**
 * Setzt die Rahmenbedingungen des Spiels zurück
 */
- (IBAction) resetSpiel:(UIButton *)sender{
    mTriesLeft = [NSNumber numberWithInt:initialTries];
}

- (void) resetRunde{
    mTriesLeft = [NSNumber numberWithInt:initialTries];
}

/**
 * Aktualisiert die aktuelle Darstellung des Spiels und setzte Buttons, etc.
 */
- (void) anzeigeAktualisieren{
    if(mTriesLeft.intValue > 0){
        // Spieler kann noch aktiv sein
        self.mBtnWuerfeln.enabled = TRUE;
        
    }
    else{
        // Spieler hat Versuche verbraucht und der Gegner ist dran
        self.mBtnWuerfeln.enabled = FALSE;
    }
}

/**
 * Nimmt die Spielinitialisierung aus der GUI entgegen.
 */
- (IBAction) setupMultiplayerGame:(id)sender{
    [self.mGCManager setupMultiplayerGame];
}

- (IBAction) rundeAusloesen:(id)sender{
    // Wir setzen den aktuellen Wert aus unseren Buttons
    
    self.mGCManager.mActualTurnValue = [mNumberFormatter numberFromString:[NSString stringWithFormat:@"%@%@%@",self.mBtn1.titleLabel.text,self.mBtn2.titleLabel.text,self.mBtn3.titleLabel.text]];
    
    // Wir lösen die nächste Runde aus und übergeben an den Gegner
    [self.mGCManager advanceMatch];
}

// Wir zeigen die aktuellen Werte an
- (void) updateGameData{
    [self.mLabelScore setText:[NSString stringWithFormat:@"%d",_mGCManager.mActualTurnValue.intValue]];
}

@end
