﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Modell;
using Datenzugriff;

namespace Website.Views.AnmeldungScaffold
{
    public class AnmeldungScaffoldController : Controller
    {
        private EFKontext db = new EFKontext();

        // GET: /AnmeldungScaffold/
        public ActionResult Index()
        {
            return View(db.TeilnehmerSet.ToList());
        }

        // GET: /AnmeldungScaffold/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Teilnehmer teilnehmer = db.TeilnehmerSet.Find(id);
            if (teilnehmer == null)
            {
                return HttpNotFound();
            }
            return View(teilnehmer);
        }

        // GET: /AnmeldungScaffold/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: /AnmeldungScaffold/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "ID,Anrede,Name,EMail,Geburtstag")] Teilnehmer teilnehmer)
        {
            if (ModelState.IsValid)
            {
                db.TeilnehmerSet.Add(teilnehmer);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(teilnehmer);
        }

        // GET: /AnmeldungScaffold/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Teilnehmer teilnehmer = db.TeilnehmerSet.Find(id);
            if (teilnehmer == null)
            {
                return HttpNotFound();
            }
            return View(teilnehmer);
        }

        // POST: /AnmeldungScaffold/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "ID,Anrede,Name,EMail,Geburtstag")] Teilnehmer teilnehmer)
        {
            if (ModelState.IsValid)
            {
                db.Entry(teilnehmer).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(teilnehmer);
        }

        // GET: /AnmeldungScaffold/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Teilnehmer teilnehmer = db.TeilnehmerSet.Find(id);
            if (teilnehmer == null)
            {
                return HttpNotFound();
            }
            return View(teilnehmer);
        }

        // POST: /AnmeldungScaffold/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
         Teilnehmer teilnehmer = db.TeilnehmerSet.Find(id);
            db.TeilnehmerSet.Remove(teilnehmer);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
