/* 
   (c) 2014 Linkwerk GmbH,
   Alle Rechte vorbehalten.

   
   Hinweis: Dies ist eine Demoversion zum 
   iX-Tutorial über jQuery Mobile (jQM).

   Neben der Demonstration einiger jQM-Features
   besitzt die Software keine Funktionen.

   Die Software ist nicht lauffähig. Der Quellcode
   dient ausschließlich der Illustration des
   in er iX erschienenen Tutorials.

*/

$(document).on( "mobileinit", function() {
    /* setting options */
    /* http://api.jquerymobile.com/global-config/ */

    $.mobile.page.prototype.options.theme = "a";
    $.mobile.popup.prototype.options.theme = "b";

    $.mobile.toolbar.prototype.options.backBtnText = "Zurück";
    $.mobile.toolbar.prototype.options.addBackBtn = true;
    $.mobile.toolbar.prototype.options.position = "fixed";

    $.mobile.collapsible.prototype.options.collapsedIcon = "carat-r";
    $.mobile.collapsible.prototype.options.expandedIcon = "carat-d";


    $.mobile.selectmenu.prototype.options.nativeMenu = false;


    $.mobile.popup.prototype.options.transition = "flip";

    /*
      Registering event handler
     */

    $(document).on("click", "#ausgabeSpeichern", function(clickEvent) {

	  // Neue Daten speichern
	  haushaltsbuch.neueAusgabe(
	      $('#kategorie').val(), 
	      Number($('#betrag').val()), 
	      $('#kommentar').val()
	  );


	  // Rückmeldung/Erfolg anzeigen
	  $("#popupGespeichert").popup("open");
	  setTimeout(
	      function() { $( "#popupGespeichert" ).popup( "close" )},
	      1000
	  );

	  // Formular zurücksetzen
	  $(this).closest("form")[0].reset();

    });

    $(document).on("click", ".detail", function(clickEvent) {
	haushaltsbuch.showDetail($(this).find("a").attr("data-timestamp"));
	console.log("Details shown");
    });


    $(document).on("pagecontainershow", "body", function( event ) {
	console.log("pagecontainershow");
	$(this).pagecontainer("getActivePage").find("#auswertungTabelle tbody").each(function() {
	    haushaltsbuch.showAuswertung($(this));
	});
    });

    $(document).on("pagecontainertransition", "body", function( event ) {
	console.log("pagecontainertransition");
    });


    $(document).on( "blur", "#betrag", function( event ) {
	var betrag = $(this).val(),
	nummerisch = !isNaN(parseFloat(betrag));
	console.log(betrag);
	console.log(nummerisch);

	if (!nummerisch) {
	    $("#popupNurZahlen").popup("open");
	    $(this).val(0);
	}
    });




    haushaltsbuch.read();
    console.log("mobileinit done " + Date.now());
});




var haushaltsbuch = (function() {

    var hbuch = this,
    ausgaben = new Array();



    /* 
       neueAusgabe(kategorie, betrag, kommentar)
       Trägt eine neue Ausgabe ins Haushaltsbuch ein.
    */
    neueAusgabe = function(kategorie, betrag, kommentar) {
	var ausgabe = {
	    "timestamp": Date.now(),
	    "kategorie": kategorie,
	    "betrag":    betrag,
	    "kommentar": kommentar
	}

	console.log(ausgabe);

	ausgaben.push(ausgabe);
	saveToRemoteStorage();

	return ausgabe;
    }


    /*
      showAuswertung(containerElement)
      Stellt die Ausgaben in einer Tabelle/tbody dar.
    */
    showAuswertung = function(containerElement) {
	readFromRemoteStorage();

	var summe = 0;

	containerElement.html("");

	for (var i=0; i<ausgaben.length; i++) {
	    
	    var pos   = i+1,
	    datum     = new Date(ausgaben[i].timestamp),
	    kategorie = ausgaben[i].kategorie,
	    betrag    = ausgaben[i].betrag;

	    $(containerElement).append(
		"<tr><td>" + pos + "</td><td>" +  datum.toLocaleDateString() + "</td><td>" +  kategorie + "</td><td>" +   betrag  + " €</td><td><span class='detail'><a href='#' data-icon='info' data-timestamp='" + ausgaben[i].timestamp  + "' class='ui-btn' data-iconpos='notext' data-role='button'>Details</a></span></td></tr>"
	    );
	    console.log(ausgaben[i].betrag);
	    summe += ausgaben[i].betrag;

	}
	$(containerElement).append("<tr><th>Summe</th><th> </th><th> </th><th>" + summe  + " €</th><th> </th></tr>");

	$(containerElement).closest("table").table( "rebuild" );
	$(containerElement).find(".detail a").button();

    }


    /*
      deleteEntry(entryId)
      Löscht einen Eintrag aus dem Haushaltsbuch.
     */
    deleteEntry = function(entryId) {
	console.log("deleteEntry");
	var gefilterteAusgaben = $.grep(ausgaben, function(ausgabe){ return ausgabe.timestamp != entryId; });


	ausgaben = gefilterteAusgaben;

	saveToRemoteStorage();
    }

    /*
      showDetail(entryId)
      Zeigt Details eines Eintrags in einem Popup. 
     */
    showDetail = function(entryId) {
	var eintraege = $.grep(ausgaben, function(ausgabe){ return ausgabe.timestamp == entryId; }),
	popupMarkup = "";



	if (eintraege.length == 0) {
	    popupMarkup = "<div>Eintrag nicht gefunden.</div>";
	} else if (eintraege.length == 1) {
	    var eintrag = eintraege[0],
	    datum     = new Date(eintrag.timestamp),

	    popupMarkup = "<a href='#' data-rel='back' data-role='button' data-theme='a' data-icon='delete' data-iconpos='notext' class='ui-btn-right'>Schließen</a>";

	    popupMarkup += "<p>" +  datum.toLocaleDateString()+ "</p>";
	    popupMarkup += "<p>" + eintrag.betrag + " €</p>";
	    popupMarkup += "<p>" + eintrag.kategorie + "</p>";
	    popupMarkup += "<p>" + eintrag.kommentar + "</p>"; 

	    popupMarkup += "<p><a href='#' data-role='button' data-icon='minus' data-iconpos='left' class='deletebutton' >Eintrag löschen</a></p>"; 
	    

	} else {
	    popupMarkup = "<div>FEHLER: Mehrere Einträge gefunden.</div>";
	}

	// Markup in's DOM einfügen...
	$("#popupEintragDetails").html(popupMarkup);

	// ... alle Kindelemente "aufpeppen" und mit Event Handlern ausstatten...
	$("#popupEintragDetails").enhanceWithin();

	$("#popupEintragDetails .deletebutton").on("click", function () {
	    deleteEntry(entryId);
	    $("#popupEintragDetails").popup("close");

	    $(this).parents("#auswertung").find("#auswertungTabelle tbody").each(function() {
		haushaltsbuch.showAuswertung($(this));
	    });

	});

	// .. und das Popup öffnen
	$("#popupEintragDetails").popup("open");
    }


    saveToRemoteStorage = function() {
	console.log("Save: Storage not implemented.");	
    }

    readFromRemoteStorage = function() {
	console.log("Load: Storage not implemented.");
    }



    /* Öffentliche Methoden nach außen geben */
    return {
	neueAusgabe: neueAusgabe,
	showAuswertung: showAuswertung,
	read: readFromRemoteStorage,
	showDetail: showDetail
    }

})();