﻿using Datenzugriff;
using Modell;
using System.Linq;
using System.Web.ModelBinding;
using System.Web.Mvc;

namespace Website.Controllers
{
 public class AnmeldungModelgetriebenController : Controller
 {
  // EKontext für Datenzugriff
  private EFKontext db = new EFKontext();

  // GET: /Veranstaltung/
  //[Authorize(Roles="Admin")]
  public ActionResult List([QueryString] int id=1)
  {
   ViewBag.Veranstaltung = db.VeranstaltungsSet.Find(id);
   return View(db.TeilnehmerSet.ToList());
  }

  // GET: /Veranstaltung/Create/1
  public ActionResult Create([QueryString] int id=1)
  {
   ViewBag.Veranstaltung = db.VeranstaltungsSet.Find(id);
   Session["ID"] = id;
   return View(new Teilnehmer());
  }

  // POST: /Veranstaltung/Create/1
  [HttpPost]
  [ValidateAntiForgeryToken]
  public ActionResult Create(Teilnehmer teilnehmer)
  {
   if (ModelState.IsValid)
   {
    db.TeilnehmerSet.Add(teilnehmer);
    db.SaveChanges();
    return RedirectToAction("List");
   }
   ViewBag.Veranstaltung = db.VeranstaltungsSet.Find(Session["ID"]);
   ViewBag.Status = "Unvollständige Eingaben!";
   return View(teilnehmer);
  }

  protected override void Dispose(bool disposing)
  {
   if (disposing)
   {
    db.Dispose();
   }
   base.Dispose(disposing);
  }
 }
}
