﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using System.Web.Http.ModelBinding;
using System.Web.Http.OData;
using System.Web.Http.OData.Routing;
using Modell;
using Datenzugriff;

namespace Website.Controllers
{
 /*
 To add a route for this controller, merge these statements into the Register method of the WebApiConfig class. Note that OData URLs are case sensitive.

 using System.Web.Http.OData.Builder;
 using Modell;
 ODataConventionModelBuilder builder = new ODataConventionModelBuilder();
 builder.EntitySet<Veranstaltung>("VeranstaltungOData");
 builder.EntitySet<Teilnehmer>("Teilnehmer"); 
 config.Routes.MapODataRoute("odata", "odata", builder.GetEdmModel());
 */
 public class VeranstaltungODataController : ODataController
 {
  private EFKontext db = new EFKontext();

  // GET odata/VeranstaltungOData
  [Queryable]
  public IQueryable<Veranstaltung> GetVeranstaltungOData()
  {
   return db.VeranstaltungsSet;
  }

  // GET odata/VeranstaltungOData(5)
  [Queryable]
  public SingleResult<Veranstaltung> GetVeranstaltung([FromODataUri] int key)
  {
   return SingleResult.Create(db.VeranstaltungsSet.Where(veranstaltung => veranstaltung.ID == key));
  }

  // PUT odata/VeranstaltungOData(5)
  public IHttpActionResult Put([FromODataUri] int key, Veranstaltung veranstaltung)
  {
   if (!ModelState.IsValid)
   {
    return BadRequest(ModelState);
   }

   if (key != veranstaltung.ID)
   {
    return BadRequest();
   }

   db.Entry(veranstaltung).State = EntityState.Modified;

   try
   {
    db.SaveChanges();
   }
   catch (DbUpdateConcurrencyException)
   {
    if (!VeranstaltungExists(key))
    {
     return NotFound();
    }
    else
    {
     throw;
    }
   }

   return Updated(veranstaltung);
  }

  // POST odata/VeranstaltungOData
  public IHttpActionResult Post(Veranstaltung veranstaltung)
  {
   if (!ModelState.IsValid)
   {
    return BadRequest(ModelState);
   }

   db.VeranstaltungsSet.Add(veranstaltung);
   db.SaveChanges();

   return Created(veranstaltung);
  }

  // PATCH odata/VeranstaltungOData(5)
  [AcceptVerbs("PATCH", "MERGE")]
  public IHttpActionResult Patch([FromODataUri] int key, Delta<Veranstaltung> patch)
  {
   if (!ModelState.IsValid)
   {
    return BadRequest(ModelState);
   }

   Veranstaltung veranstaltung = db.VeranstaltungsSet.Find(key);
   if (veranstaltung == null)
   {
    return NotFound();
   }

   patch.Patch(veranstaltung);

   try
   {
    db.SaveChanges();
   }
   catch (DbUpdateConcurrencyException)
   {
    if (!VeranstaltungExists(key))
    {
     return NotFound();
    }
    else
    {
     throw;
    }
   }

   return Updated(veranstaltung);
  }

  // DELETE odata/VeranstaltungOData(5)
  public IHttpActionResult Delete([FromODataUri] int key)
  {
   Veranstaltung veranstaltung = db.VeranstaltungsSet.Find(key);
   if (veranstaltung == null)
   {
    return NotFound();
   }

   db.VeranstaltungsSet.Remove(veranstaltung);
   db.SaveChanges();

   return StatusCode(HttpStatusCode.NoContent);
  }

  // GET odata/VeranstaltungOData(5)/Teilnehmerliste
  [Queryable]
  public IQueryable<Teilnehmer> GetTeilnehmerliste([FromODataUri] int key)
  {
   return db.VeranstaltungsSet.Where(m => m.ID == key).SelectMany(m => m.Teilnehmerliste);
  }

  protected override void Dispose(bool disposing)
  {
   if (disposing)
   {
    db.Dispose();
   }
   base.Dispose(disposing);
  }

  private bool VeranstaltungExists(int key)
  {
   return db.VeranstaltungsSet.Count(e => e.ID == key) > 0;
  }
 }
}
