#!/bin/bash

echo "CheckBoot 1.2 - Usage at your own risk. This little tool is public domain.";

# Variablen
TIME=`date +%Y-%m-%d--%H:%M:%S`	
# Used as a temorary mount point
MNTP=`pwd`/fu7aiShuye7VoojoDeeW3aeheeKee9qu

if [ "$1" == "-h" ] || [ "$1" == "--help" ] || [ "$1" == "" ]; then
	echo "Options: -h, --help, -v"
	echo "! CheckBoot must be run as root !"
	echo "! GPT size > 63*512 not supported !"
	echo ""
	echo "You have to enter three arguments."
	echo "Argument one -d: device file"
	echo "   - The device which holds the boot area (MBR/GPT), e.g. /dev/sda"
	echo "Argument two -b: boot partition"
	echo "   - The device file of the boot partition (contains clear text files), e.g. /dev/sda1"
	echo "Argument three -f: check-dir"
	echo "   - You have to enter a check directory (e.g. computer name)."
	echo "   - A directory will be created in your current folder (e.g. ./computer_name)"
	echo "   - In this directory the checksums are going to be stored."
 	echo "   - If you run CheckBoot a second time with the same computer name,"
	echo "     these checksums will be used to compare the checksums of the INIT phase (e.g. /dev/sda and /dev/sda1."
	echo "Example:"
	echo "   checkboot.sh DEVICE DEVICEFILE BOOTPARTITION COMPUTERNAME"
	echo "   checkboot.sh -d /dev/sda -b /dev/sda1 -f example_PC"
	exit 1 
fi 

if [ "$(id -u)" != "0" ]; then
   echo "CheckBoot must be run as root" 
   exit 1
fi

while getopts "vd:b:f:" options; do
  case $options in
    v ) echo "Usage at your own risk. This little tool is public domain."
	echo "Authors: Gunnar Friessner, Hendrik Adam"
	echo "Contact: info@digitrace.de"
	exit 1
	;;
    d ) DEVICEFILE=$OPTARG
	;;
    b ) BOOTFILE=$OPTARG
	;;
    f ) OUTPUT=$OPTARG
	;;
  esac
done

if [ "$DEVICEFILE" == "" ] || [ "$BOOTFILE" == "" ] || [ "$OUTPUT" == "" ]; then
	echo "One or more arguments are missing"
	echo "Please use -h to see which arguments to provide"
	exit 0
fi


#Check if directory exists and if it is mounted.
if [ "MNTP" != "" ]; then
	echo "The mount directory of $BOOTFILE is $MNTP"
	if [ -d "MNTP" ]
		then
			echo "This directory exists! Please choose a different directory."
			echo "Is it a common Linux directory?"
			exit 1
	else
		mkdir $MNTP/
		mount -o ro $BOOTFILE $MNTP	
	fi
	#Check again - just in case of something went wrong. 
	if grep -qs $MNTP /proc/mounts; then
   		echo "Device is mounted. The content of $MNTP is:"
		ls $MNTP/
		echo "End of content $MNTP."
	else
		echo "Could not mount $BOOTFILE to $MNTP. Stopping the script."#
		exit 1
	fi
fi

if [ ! -d "$OUTPUT" ]; then
	mkdir $OUTPUT
fi

#recheck - just in case something went wrong.
if [ -d "$OUTPUT" ]; then
	DIR=$(dir $MNTP/)
	echo  "$TIME Content of $MNTP: $DIR"  >> $OUTPUT/log.txt 
	#Loop of the files in mount.
	if [  -f $OUTPUT/filehashes.txt ]; then
		echo "Checking if files are modified in $MNTP."
		if [ -f $OUTPUT/filehashes.txt.temp ]; then
				rm $OUTPUT/filehashes.txt.temp
				echo  "$TIME $OUTPUT/filehashes.txt.temp is removed."  >> $OUTPUT/log.txt
		fi

		find $MNTP ! -type d -print0 | xargs -0 sha256sum >> $OUTPUT/filehashes.txt.temp
		
		DIFF=$(diff $OUTPUT/filehashes.txt $OUTPUT/filehashes.txt.temp)
		if [ "$DIFF" != "" ]; then
			diff $OUTPUT/filehashes.txt $OUTPUT/filehashes.txt.temp
			echo "ALERT! The files have been modified."
			echo  "$TIME ALERT! The files have been modified."  >> $OUTPUT/log.txt
			echo  "$TIME Diff: $DIFF"  >> $OUTPUT/log.txt
		else	
			echo "The files weren't modified. The checksums are identical."
			echo  "$TIME The files weren't modified. The checksums are identical."  >> $OUTPUT/log.txt
			if [ -f $OUTPUT/filehashes.txt.temp ]; then
				rm $OUTPUT/filehashes.txt.temp
				echo  "$TIME $OUTPUT/filehashes.txt.temp is removed."  >> $OUTPUT/log.txt
				
			fi
		fi
	else 
		
		find $MNTP ! -type d -print0 | xargs -0 sha256sum >>$OUTPUT/filehashes.txt
		echo "There were no file hashes. File hashes have been created in $OUTPUT."
		echo  "$TIME There were no file hashes. File hashes have been created in $OUTPUT." >> $OUTPUT/log.txt
		
	fi	
	if [  -f $OUTPUT/mbr.checksum ]; then
		echo "Checking if the file hash of the Master Boot Record is modified."
		if [ -f $OUTPUT/mbr.checksum.temp ]; then
			rm $OUTPUT/mbr.checksum.temp
			echo  "$TIME $OUTPUT/mbr.checksum.temp is removed."  >> $OUTPUT/log.txt
		fi
		dd if=$DEVICEFILE bs=512 count=63 2>/dev/null | sha256sum >  $OUTPUT/mbr.checksum.temp
		DIFF=$(diff $OUTPUT/mbr.checksum $OUTPUT/mbr.checksum.temp)
		if [ "$DIFF" != "" ]; then
			diff $OUTPUT/mbr.checksum $OUTPUT/mbr.checksum.temp
			echo "ALERT! The Master Boot Record was modified."
			echo  "$TIME ALERT! The Master Boot Record was modified."  >> $OUTPUT/log.txt
			echo  "$TIME Diff: $DIFF"  >> $OUTPUT/log.txt
		else	
			echo "The Master Boot Record was not modified."
			echo  "$TIME The Master Boot Record was not modified."  >> $OUTPUT/log.txt
			if [ -f $OUTPUT/mbr.checksum.temp ]; then
				rm $OUTPUT/mbr.checksum.temp
				echo  "$TIME $OUTPUT/mbr.checksum.temp is removed."  >> $OUTPUT/log.txt
			fi
		fi
	else
		echo "There was no file hash of the Master Boot Record. It is created now in $OUTPUT."
		dd if=$DEVICEFILE bs=512 count=63 2>/dev/null | sha256sum >  $OUTPUT/mbr.checksum
		echo  "$TIME There was no file hash of the Master Boot Record. It is created now in $OUTPUT." >> $OUTPUT/log.txt
	fi 
else
	echo "Couldn't create $OUTPUT."
	echo  "$TIME Couldn't create $OUTPUT." >> $OUTPUT/log.txt
fi

#umount and remove the directory of umount point.
if grep -qs $MNTP /proc/mounts; then
		
		umount $MNTP
		FILE=""
		# init
		# look for empty dir 
		if [ "$(ls -A $MNTP)" ]; then
     			echo "The directory $MNTP is not empty and could not be unmounted. Please do it manual."
			echo  "$TIME The directory $MNTP is not empty and could not be unmounted. Please do it manual." >> $OUTPUT/log.txt
		else
	 	 	echo "The directory $MNTP could be unmounted and the directory is empty."
			echo  "$TIME The directory $MNTP could be unmounted and the directory is empty." >> $OUTPUT/log.txt
			rmdir $MNTP/
			if [ ! -d "$MNTP" ]; then
				echo "The directory $MNTP is deleted."
				echo  "$TIME The directory $MNTP is deleted." >> $OUTPUT/log.txt
			else 
				echo "The directory $MNTP could not be removed. Please check if it is really umounted and empty."
				echo  "$TIME The directory $MNTP could not be removed. Please check if it is really umounted and empty." >> $OUTPUT/log.txt
			fi	
		fi
fi
