﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AvalonDock;
using System.Collections.ObjectModel;

namespace WPFDocking
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            MyDocuments = new ObservableCollection<DocumentContent>();
            DataContext = this;
            this.CommandBindings.Add(new CommandBinding(ApplicationCommands.New, New_Executed));
        }
        public ObservableCollection<DocumentContent> MyDocuments { get; private set; }
        private void New_Executed(object sender, ExecutedRoutedEventArgs e)
        {
            string baseDocTitle = "MyDocument";
            int i = 1;
            string title = baseDocTitle + i.ToString();

            while (dockManager.Documents.Any(d => d.Title == title))
            {
                i++;
                title = baseDocTitle + i.ToString();
            }

            MyDocuments.Add(new Kind() { Title = title });
        }
    }
}
