/* Fortgeschrittene C++-Features in <I>bindRoot.cpp<I> */

#include <memory>
#include <functional> // for std::bind, std::function, std::ref, lambda-functions
#include <random>
#include <string>

#include <vector>
#include <algorithm>
#include <iostream>

class secret_value {
public:
  secret_value(double d) :secret_(d) { /* nothing */ }
  double value() const { return secret_; }

private:
  secret_value() = delete;
  double secret_;
};

typedef std::random_device random_device;
typedef std::uniform_real_distribution<double> rnd_double_01;
typedef std::shared_ptr<secret_value> sv_ptr;

void bindRoot() {
  rnd_double_01 double_01;
  random_device generator;
  std::function<double()> r  = std::bind(double_01, std::ref(generator));

  std::vector<sv_ptr> sv; // "secret_vector"
  for(std::size_t i=0; i<5; i++){
    sv.push_back(sv_ptr(new secret_value(r())));
    std::cout << i << ": " << sv[i]->value() << std::endl;
  }

  std::cout << std::endl;
  std::string message = "sorting";
  std::sort(
     sv.begin()
     , sv.end()
     , [=](sv_ptr a, sv_ptr b) /* -> bool */ {
       std::cout << message << std::endl;
       return a->value() < b->value();
     }
  );

  std::cout << std::endl;
  for(auto it=sv.begin(); it!=sv.end(); ++it) {
    std::cout << (*it)->value() << std::endl;
  }
}

!!!Ende Listing 2
