/* threadClassWithDefault.cpp */

#include <iostream>
#include <thread>
#include <functional> // for std::bind

const int NCOUNTS = 100; // some constants
const int INCREMENT = 0;
const int DECREMENT = 1;

int counter;
std::mutex incrementMutex;

class Counter {
public:
  Counter() = default;

  Counter(int nCounts, int countSwitcher) 
    : nCounts_(nCounts)
    , countSwitcher_(countSwitcher)
  { /* nothing */ }

  void operator()() { // Accepts no arguments
    switch(countSwitcher_) {
    case 0:
      increment();
      break;

    case 1:
      decrement();
      break;

    default: // Complain
      throw;
    }
  }

  void increment() {
    for(int i=0; i<nCounts_; i++) {
      std::lock_guard<std::mutex> lk(incrementMutex);
      counter++;
      std::cout << counter << std::endl;
    }
  }

  void decrement() {
    for(int i=0; i<nCounts_; i++) {
      std::lock_guard<std::mutex> lk(incrementMutex);
      counter--;
      std::cout << counter << std::endl;
    }
  }

private:
  int nCounts_ = NCOUNTS;
  int countSwitcher_ = INCREMENT;
};

// Equivalent to main() in our context
void threadClassWithDefault() {
  counter = 0;

  // Start the threads
  std::thread a(Counter(NCOUNTS, INCREMENT));
  std::thread b(Counter(NCOUNTS, DECREMENT));

  // Wait for their termination
  a.join();
  b.join();
}
