angular.module('stock')
    .factory('stockItems', stockItems);

stockItems.$inject = ['$websocket'];

function stockItems($websocket) {
    var stream = $websocket('ws://localhost:8080/stockItems');

    var stockItems = [];

    var callbacks = {};
    stream.onMessage(function(message) {
        var item = JSON.parse(message.data);

        if (item.hasOwnProperty('action')) {
            switch (item.action) {
                case 'positive':
                    trigger('positive', item.data.id);
                    break;
                case 'negative':
                    trigger('negative', item.data.id);
                    break;
                case 'locked':
                    trigger('locked', item);
                    return;
                    break;
            }
            stockItems.forEach(function (stockItem) {
                if (stockItem.id === item.data.id) {
                    stockItem.stock = item.data.stock;
                }
            });
        } else {
            if(angular.isArray(item)) {
                item.forEach(function (data) {
                    stockItems.push(data);
                });
            } else {
                stockItems.forEach(function (stockItem) {
                    if (stockItem.id === item.id) {
                        stockItem.stock = item.stock;
                    }
                });
                stockItems.push(item);
            }
        }
    });

    return {
        callbacks: callbacks,
        stockItems: stockItems,
        get: get,
        increase: increase,
        decrease: decrease,
        save: save,
        on: on,
        trigger: trigger
    };

    function get() {
        stream.send(JSON.stringify({action: 'get'}));
    }

    function increase(item) {
        increaseDecrease(item, 1);
    }

    function decrease(item) {
        increaseDecrease(item, -1);
    }

    function increaseDecrease(item, value) {
        if (item.locked) {
            return;
        }
        var stock = 0;
        stockItems.forEach(function (stockItem) {
            if (stockItem.id === item.id) {
                stock = stockItem.stock;
            }
        });

        var data = {
            id: item.id,
            stock: stock + value
        };

        save(data);
    }

    function save(data) {
        stream.send(JSON.stringify({action: 'save', data: data}));
    }

    function on(evt, cb) {
        if (callbacks.hasOwnProperty(evt)) {
            callbacks[evt].push(cb);
        } else {
            callbacks[evt] = [cb];
        }
    }

    function trigger(evt, data) {
        if (callbacks.hasOwnProperty(evt)) {
            callbacks[evt].forEach(function(callback) {
                callback(data);
            });
        }
    }
}
