#!/usr/bin/gnuplot --persist

set term x11

set style data linespoints

set key

# X- und Y-Achsenbeschriftung

#set title "Edelmetallpreise 2015"
#set xlabel "Datum"
#set ylabel "Preis"

# Labels und "stumme" Ticks an der X-Achse
set xtics ("1. Juli" 1, "" 5, "" 10, "15. Juli" 15, "" 20, "" 25, "30. Juli" 30)

set xrange [0:32]
set yrange [0:180]

# Um der Verschiebung (s. unten) Rechnung zu tragen, labeln wir die y-Achse
# entsprechend um und fügen Trennmarkierungen ein
set ytics ("14" 0, "15" 30, "16" 60, "1080" 80, "1100" 100, "1120" 120, "1140" 140, "1160" 160, "1180" 180)
set ytics ("" 0, "" 30, "" 60, "" 80, "" 100, "" 120, "" 140, "" 160, "" 180)
set y2tics ("14" 0, "15" 30, "16" 60, "" 80, "1100" 100, "" 120, "1140" 140, "" 160, "1180" 180)
set grid

# Und die "Snips" in den Achsen:
set border 1+4
set arrow 1 from 0,0 to 0,67 nohead
set arrow 2 from 0,73 to 0,180 nohead
set arrow 3 from 32,0 to 32,67 nohead
set arrow 4 from 32,73 to 32,180 nohead

set arrow 5 from -0.5,65 to 0.5,69 nohead
set arrow 6 from -0.5,71 to 0.5,75 nohead

set arrow 7 from 31.5,65 to 32.5,69 nohead
set arrow 8 from 31.5,71 to 32.5,75 nohead

# Um die Details der beiden Kurven besser zu erkennen, verschieben wir und
# skalieren ein wenig um
p "metalle" u 1:($2 - 1000) pt 6 ps 0.2 lc 4 t "Gold", "" u 1:(30*($3 - 14)) pt 6 ps 0.2 lc 3 t "Silber"

set term pdfcairo size 5cm,3cm font ",9" crop
set output "metalle.pdf"
replot
set output

set term png size 500,300
set output "metalle.png"
replot
set output
