package freightlist;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;

public class Judge implements EasyScoreCalculator<Freightlist> {

	public Score calculateScore(Freightlist arg0) {

		int hardScore = 0;
		int softScore = 0;

		for (Freightlist theTrunk : arg0.getFreightlists()) {

			int spaceUsed = 0;
			int weightUsed = 0;
			int totalProfit = 0;

			boolean used = false;
			for (Luggage piece : arg0.getLuggageList()) {
				if (theTrunk.equals(piece.getFreighlist())) {
					spaceUsed += piece.getSize();
					weightUsed += piece.getWeight();
					totalProfit += piece.getProfit();
					used = true;

				} else {
					// not used
					if (piece.isRequired()) {// unterschied
						hardScore -= 1;
					}
				}

			}

			// Hard constraints

			int spaceAvailable = 15 - spaceUsed;

			if (spaceAvailable < 0) {
				hardScore += spaceAvailable; // as spaceAvailable is negative
												// this will REDUCE hardscore

			}

			int weightAvailable = 150 - weightUsed;

			if (weightAvailable < 0) {
				hardScore += weightAvailable;
			}

			// Soft constraints

			if (used) {
				softScore += totalProfit;
			}

		}

		return HardSoftScore.valueOf(hardScore, softScore);

	}

}
