package freightlist;

import java.util.ArrayList;
import java.util.List;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;

public class Main {

	private static Freightlist createRessourcesToOptimize() {

		Freightlist theFreightlist = new Freightlist();

		List<Freightlist> allFlightLists = new ArrayList<Freightlist>(2);
		Freightlist onlyFreighlist = new Freightlist();
		allFlightLists.add(onlyFreighlist);
		theFreightlist.setFreightlist(allFlightLists);

		List<Luggage> luggageList = new ArrayList<Luggage>(6);
		Luggage piece = new Luggage();
		piece.setLabel("Spare part aircraft repair (AOG)");
		piece.setSize(1);
		piece.setWeight(1);
		piece.setProfit(10);
		piece.setRequired(true);

		// Notice that we leave the PlanningVariable properties on null
		
		luggageList.add(piece);
		piece = new Luggage();
		piece.setLabel("Diving equipment customer A");
		piece.setSize(8);
		piece.setWeight(30);
		piece.setProfit(5);
		luggageList.add(piece);
		piece = new Luggage();
		piece.setLabel("Freight customer B");
		piece.setSize(2);
		piece.setWeight(2);
		piece.setProfit(7);
		luggageList.add(piece);

		piece = new Luggage();
		piece.setLabel("Freight customer C");
		piece.setSize(4);
		piece.setWeight(3);
		piece.setProfit(12);
		piece.setRequired(true);
		luggageList.add(piece);

		piece = new Luggage();
		piece.setLabel("Sky diving equipment customer D");
		piece.setSize(40);
		piece.setWeight(10);
		piece.setProfit(8);
		luggageList.add(piece);
		
		piece = new Luggage();
		piece.setLabel("Emergency equipment");
		piece.setSize(2);
		piece.setWeight(2);
		piece.setProfit(9);
		piece.setRequired(true);
		luggageList.add(piece);
		
		theFreightlist.setLuggageList(luggageList);
		return theFreightlist;
	}

	public static void main(String[] args) {
		System.out.println("Calculating freight:");

		// Build the Solver

		SolverFactory<Freightlist> solverFactory = SolverFactory.createEmpty();
		// Solver solver = solverFactory.buildSolver();

		SolverConfig sc = solverFactory.getSolverConfig();
		sc.setSolutionClass(Freightlist.class);

		ArrayList<Class> entities = new ArrayList<Class>();
		entities.add(Luggage.class);
		sc.setEntityClassList((List) entities);
		ScoreDirectorFactoryConfig sdc = new ScoreDirectorFactoryConfig();

		sdc.setScoreDefinitionType(ScoreDefinitionType.HARD_SOFT);
		sdc.setEasyScoreCalculatorClass(Judge.class);
		sc.setScoreDirectorFactoryConfig(sdc);
		TerminationConfig tc = new TerminationConfig();
		//tc.setUnimprovedStepCountLimit(1000);
		tc.setSecondsSpentLimit(1L);

		sc.setTerminationConfig(tc);

		Solver<Freightlist> solver = solverFactory.buildSolver();

		Freightlist unsolvedLuggage = createRessourcesToOptimize();

		// Solve the problem

		solver.solve(unsolvedLuggage);

		Freightlist solvedLuggage = (Freightlist) solver.getBestSolution();

		// Display the result
		if (solvedLuggage.getScore().getHardScore() < 0) {
			System.err.println("Does not yet look feasible: hard score " + solvedLuggage.getScore().getHardScore());
		} else {
			System.out.println("Feasibility " + solvedLuggage.getScore().getHardScore() + " Gain "
					+ solvedLuggage.getScore().getSoftScore());

			StringBuilder displayString = new StringBuilder();
			displayString.append("Solution:\n");
			for (Luggage piece : solvedLuggage.getLuggageList()) {
				Freightlist theFreightlist = piece.getFreighlist();
				displayString.append("  ").append(piece.getLabel()).append(" -> ")
						.append(theFreightlist == null ? "airport" : "plane").append("\n");
			}
			System.out.println(displayString.toString());
		}
	}
}
