﻿/* tslint:disable */
//----------------------
// <auto-generated>
//     Generated using the NSwag toolchain v8.8.6231.36137 (NJsonSchema v7.7.6231.35489) (http://NSwag.org)
// </auto-generated>
//----------------------

import 'rxjs/Rx'; 
import {Observable} from 'rxjs/Observable';
import {Injectable, Inject, Optional, OpaqueToken} from '@angular/core';
import {Http, Headers, Response, RequestOptionsArgs} from '@angular/http';

export const API_BASE_URL = new OpaqueToken('API_BASE_URL');

@Injectable()
export class MiracleListProxy {
    private http: Http = null; 
    private baseUrl: string = undefined; 
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(@Inject(Http) http: Http, @Optional() @Inject(API_BASE_URL) baseUrl?: string) {
        this.http = http; 
        this.baseUrl = baseUrl ? baseUrl : "https://miraclelistbackend.azurewebsites.net"; 
    }

    about(): Observable<string[]> {
        let url_ = this.baseUrl + "/About";

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processAbout(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processAbout(response));
                } catch (e) {
                    return <Observable<string[]>><any>Observable.throw(e);
                }
            } else
                return <Observable<string[]>><any>Observable.throw(response);
        });
    }

    protected processAbout(response: Response): string[] {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: string[] = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [];
                for (let item of resultData200)
                    result200.push(item);
            }
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    login(loginInfo: LoginInfo): Observable<LoginInfo> {
        let url_ = this.baseUrl + "/Login";

        const content_ = JSON.stringify(loginInfo ? loginInfo.toJS() : null);
        
        return this.http.request(url_, {
            body: content_,
            method: "post",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processLogin(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processLogin(response));
                } catch (e) {
                    return <Observable<LoginInfo>><any>Observable.throw(e);
                }
            } else
                return <Observable<LoginInfo>><any>Observable.throw(response);
        });
    }

    protected processLogin(response: Response): LoginInfo {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: LoginInfo = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            result200 = resultData200 ? LoginInfo.fromJS(resultData200) : null;
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    logoff(token: string): Observable<boolean> {
        let url_ = this.baseUrl + "/Logoff/{token}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processLogoff(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processLogoff(response));
                } catch (e) {
                    return <Observable<boolean>><any>Observable.throw(e);
                }
            } else
                return <Observable<boolean>><any>Observable.throw(response);
        });
    }

    protected processLogoff(response: Response): boolean {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: boolean = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            result200 = resultData200 !== undefined ? resultData200 : null;
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    categorySet(token: string): Observable<Category[]> {
        let url_ = this.baseUrl + "/CategorySet/{token}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processCategorySet(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processCategorySet(response));
                } catch (e) {
                    return <Observable<Category[]>><any>Observable.throw(e);
                }
            } else
                return <Observable<Category[]>><any>Observable.throw(response);
        });
    }

    protected processCategorySet(response: Response): Category[] {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Category[] = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [];
                for (let item of resultData200)
                    result200.push(Category.fromJS(item));
            }
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    taskSet(token: string, id: number): Observable<Task[]> {
        let url_ = this.baseUrl + "/TaskSet/{token}/{id}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token)); 
        
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processTaskSet(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processTaskSet(response));
                } catch (e) {
                    return <Observable<Task[]>><any>Observable.throw(e);
                }
            } else
                return <Observable<Task[]>><any>Observable.throw(response);
        });
    }

    protected processTaskSet(response: Response): Task[] {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Task[] = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [];
                for (let item of resultData200)
                    result200.push(Task.fromJS(item));
            }
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    task(token: string, id: number): Observable<Task> {
        let url_ = this.baseUrl + "/Task/{token}/{id}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token)); 
        
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processTask(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processTask(response));
                } catch (e) {
                    return <Observable<Task>><any>Observable.throw(e);
                }
            } else
                return <Observable<Task>><any>Observable.throw(response);
        });
    }

    protected processTask(response: Response): Task {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Task = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            result200 = resultData200 ? Task.fromJS(resultData200) : null;
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    search(token: string, text: string): Observable<Category[]> {
        let url_ = this.baseUrl + "/Search/{token}/{text}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token)); 
        
        if (text === undefined || text === null)
            throw new Error("The parameter 'text' must be defined.");
        url_ = url_.replace("{text}", encodeURIComponent("" + text));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processSearch(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processSearch(response));
                } catch (e) {
                    return <Observable<Category[]>><any>Observable.throw(e);
                }
            } else
                return <Observable<Category[]>><any>Observable.throw(response);
        });
    }

    protected processSearch(response: Response): Category[] {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Category[] = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [];
                for (let item of resultData200)
                    result200.push(Category.fromJS(item));
            }
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    dueTaskSet(token: string): Observable<Category[]> {
        let url_ = this.baseUrl + "/DueTaskSet/{token}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "get",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            console.log(response);
            return this.processDueTaskSet(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processDueTaskSet(response));
                } catch (e) {
                    return <Observable<Category[]>><any>Observable.throw(e);
                }
            } else
                return <Observable<Category[]>><any>Observable.throw(response);
        });
    }

    protected processDueTaskSet(response: Response): Category[] {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Category[] = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            if (resultData200 && resultData200.constructor === Array) {
                result200 = [];
                for (let item of resultData200)
                    result200.push(Category.fromJS(item));
            }
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    createTask(token: string, t: Task): Observable<Task> {
        let url_ = this.baseUrl + "/CreateTask/{token}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));

        const content_ = JSON.stringify(t ? t.toJS() : null);
        
        return this.http.request(url_, {
            body: content_,
            method: "post",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processCreateTask(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processCreateTask(response));
                } catch (e) {
                    return <Observable<Task>><any>Observable.throw(e);
                }
            } else
                return <Observable<Task>><any>Observable.throw(response);
        });
    }

    protected processCreateTask(response: Response): Task {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Task = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            result200 = resultData200 ? Task.fromJS(resultData200) : null;
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    changeTask(token: string, t: Task): Observable<Task> {
        let url_ = this.baseUrl + "/ChangeTask/{token}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));

        const content_ = JSON.stringify(t ? t.toJS() : null);
        
        return this.http.request(url_, {
            body: content_,
            method: "put",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processChangeTask(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processChangeTask(response));
                } catch (e) {
                    return <Observable<Task>><any>Observable.throw(e);
                }
            } else
                return <Observable<Task>><any>Observable.throw(response);
        });
    }

    protected processChangeTask(response: Response): Task {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Task = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            result200 = resultData200 ? Task.fromJS(resultData200) : null;
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    deleteTask(token: string, id: number): Observable<void> {
        let url_ = this.baseUrl + "/DeleteTask/{token}/{id}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token)); 
        
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "delete",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processDeleteTask(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processDeleteTask(response));
                } catch (e) {
                    return <Observable<void>><any>Observable.throw(e);
                }
            } else
                return <Observable<void>><any>Observable.throw(response);
        });
    }

    protected processDeleteTask(response: Response): void {
        const responseText = response.text();
        const status = response.status; 

        if (status === 204) {
            return null;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    deleteCategory(token: string, id: number): Observable<void> {
        let url_ = this.baseUrl + "/DeleteCategory/{token}/{id}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token)); 
        
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "delete",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processDeleteCategory(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processDeleteCategory(response));
                } catch (e) {
                    return <Observable<void>><any>Observable.throw(e);
                }
            } else
                return <Observable<void>><any>Observable.throw(response);
        });
    }

    protected processDeleteCategory(response: Response): void {
        const responseText = response.text();
        const status = response.status; 

        if (status === 204) {
            return null;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    createCategory(token: string, name: string): Observable<Category> {
        let url_ = this.baseUrl + "/CreateCategory/{token}/{name}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token)); 
        
        if (name === undefined || name === null)
            throw new Error("The parameter 'name' must be defined.");
        url_ = url_.replace("{name}", encodeURIComponent("" + name));

        const content_ = "";
        
        return this.http.request(url_, {
            body: content_,
            method: "post",
            headers: new Headers({
                "Content-Type": "application/json; charset=UTF-8", 
				"Accept": "application/json; charset=UTF-8"
            })
        }).map((response) => {
            return this.processCreateCategory(response);
        }).catch((response: any, caught: any) => {
            if (response instanceof Response) {
                try {
                    return Observable.of(this.processCreateCategory(response));
                } catch (e) {
                    return <Observable<Category>><any>Observable.throw(e);
                }
            } else
                return <Observable<Category>><any>Observable.throw(response);
        });
    }

    protected processCreateCategory(response: Response): Category {
        const responseText = response.text();
        const status = response.status; 

        if (status === 200) {
            let result200: Category = null;
            let resultData200 = responseText === "" ? null : JSON.parse(responseText, this.jsonParseReviver);
            result200 = resultData200 ? Category.fromJS(resultData200) : null;
            return result200;
        } else if (status !== 200 && status !== 204) {
            this.throwException("An unexpected server error occurred.", status, responseText);
        }
        return null;
    }

    protected throwException(message: string, status: number, response: string, result?: any): any {
        if(result !== null && result !== undefined)
            throw result;
        else
            throw new SwaggerException(message, status, response);
    }
}

export class LoginInfo { 
    clientID?: string; 
    username?: string; 
    password?: string; 
    token?: string;
    constructor(data?: any) {
        if (data !== undefined) {
            this.clientID = data["clientID"] !== undefined ? data["clientID"] : null;
            this.username = data["username"] !== undefined ? data["username"] : null;
            this.password = data["password"] !== undefined ? data["password"] : null;
            this.token = data["token"] !== undefined ? data["token"] : null;
        }
    }

    static fromJS(data: any): LoginInfo {
        return new LoginInfo(data);
    }

    toJS(data?: any) {
        data = data === undefined ? {} : data;
        data["clientID"] = this.clientID !== undefined ? this.clientID : null;
        data["username"] = this.username !== undefined ? this.username : null;
        data["password"] = this.password !== undefined ? this.password : null;
        data["token"] = this.token !== undefined ? this.token : null;
        return data; 
    }

    toJSON() {
        return JSON.stringify(this.toJS());
    }

    clone() {
        const json = this.toJSON();
        return new LoginInfo(JSON.parse(json));
    }
}

export class CategoryBase { 
    categoryID: number; 
    name?: string; 
    created: Date; 
    taskSet?: Task[]; 
    user?: User; 
    userID: number;
    constructor(data?: any) {
        if (data !== undefined) {
            this.categoryID = data["categoryID"] !== undefined ? data["categoryID"] : null;
            this.name = data["name"] !== undefined ? data["name"] : null;
            this.created = data["created"] ? new Date(data["created"].toString()) : null;
            if (data["taskSet"] && data["taskSet"].constructor === Array) {
                this.taskSet = [];
                for (let item of data["taskSet"])
                    this.taskSet.push(Task.fromJS(item));
            }
            this.user = data["user"] ? User.fromJS(data["user"]) : null;
            this.userID = data["userID"] !== undefined ? data["userID"] : null;
        }
    }

    static fromJS(data: any): Category {
        return new Category(data);
    }

    toJS(data?: any) {
        data = data === undefined ? {} : data;
        data["categoryID"] = this.categoryID !== undefined ? this.categoryID : null;
        data["name"] = this.name !== undefined ? this.name : null;
        data["created"] = this.created ? this.created.toISOString() : null;
        if (this.taskSet && this.taskSet.constructor === Array) {
            data["taskSet"] = [];
            for (let item of this.taskSet)
                data["taskSet"].push(item.toJS());
        }
        data["user"] = this.user ? this.user.toJS() : null;
        data["userID"] = this.userID !== undefined ? this.userID : null;
        return data; 
    }

    toJSON() {
        return JSON.stringify(this.toJS());
    }

    clone() {
        const json = this.toJSON();
        return new Category(JSON.parse(json));
    }
}

export class Category extends CategoryBase {
    get info() {
        return this.name;
    }
}

export class TaskBase { 
    taskID: number; 
    title?: string; 
    created: Date; 
    due?: Date; 
    importance?: Importance; 
    note?: string; 
    done: boolean; 
    effort?: number; 
    order: number; 
    subTaskSet?: SubTask[]; 
    category?: Category; 
    categoryID: number;
    constructor(data?: any) {
        if (data !== undefined) {
            this.taskID = data["taskID"] !== undefined ? data["taskID"] : null;
            this.title = data["title"] !== undefined ? data["title"] : null;
            this.created = data["created"] ? new Date(data["created"].toString()) : null;
            this.due = data["due"] ? new Date(data["due"].toString()) : null;
            this.importance = data["importance"] !== undefined ? data["importance"] : null;
            this.note = data["note"] !== undefined ? data["note"] : null;
            this.done = data["done"] !== undefined ? data["done"] : null;
            this.effort = data["effort"] !== undefined ? data["effort"] : null;
            this.order = data["order"] !== undefined ? data["order"] : null;
            if (data["subTaskSet"] && data["subTaskSet"].constructor === Array) {
                this.subTaskSet = [];
                for (let item of data["subTaskSet"])
                    this.subTaskSet.push(SubTask.fromJS(item));
            }
            this.category = data["category"] ? Category.fromJS(data["category"]) : null;
            this.categoryID = data["categoryID"] !== undefined ? data["categoryID"] : null;
        }
    }

    static fromJS(data: any): Task {
        return new Task(data);
    }

    toJS(data?: any) {
        data = data === undefined ? {} : data;
        data["taskID"] = this.taskID !== undefined ? this.taskID : null;
        data["title"] = this.title !== undefined ? this.title : null;
        data["created"] = this.created ? this.created.toISOString() : null;
        data["due"] = this.due ? this.due.toISOString() : null;
        data["importance"] = this.importance !== undefined ? this.importance : null;
        data["note"] = this.note !== undefined ? this.note : null;
        data["done"] = this.done !== undefined ? this.done : null;
        data["effort"] = this.effort !== undefined ? this.effort : null;
        data["order"] = this.order !== undefined ? this.order : null;
        if (this.subTaskSet && this.subTaskSet.constructor === Array) {
            data["subTaskSet"] = [];
            for (let item of this.subTaskSet)
                data["subTaskSet"].push(item.toJS());
        }
        data["category"] = this.category ? this.category.toJS() : null;
        data["categoryID"] = this.categoryID !== undefined ? this.categoryID : null;
        return data; 
    }

    toJSON() {
        return JSON.stringify(this.toJS());
    }

    clone() {
        const json = this.toJSON();
        return new Task(JSON.parse(json));
    }
}

export class Task extends TaskBase {
    get info() {
        return this.title + ": " + this.subTaskSet + " Augaben";
    }
}

export enum Importance {
    A = 0, 
    B = 1, 
    C = 2, 
}

export class SubTaskBase { 
    subTaskID: number; 
    title?: string; 
    done: boolean; 
    created: Date; 
    task?: Task; 
    taskID: number;
    constructor(data?: any) {
        if (data !== undefined) {
            this.subTaskID = data["subTaskID"] !== undefined ? data["subTaskID"] : null;
            this.title = data["title"] !== undefined ? data["title"] : null;
            this.done = data["done"] !== undefined ? data["done"] : null;
            this.created = data["created"] ? new Date(data["created"].toString()) : null;
            this.task = data["task"] ? Task.fromJS(data["task"]) : null;
            this.taskID = data["taskID"] !== undefined ? data["taskID"] : null;
        }
    }

    static fromJS(data: any): SubTask {
        return new SubTask(data);
    }

    toJS(data?: any) {
        data = data === undefined ? {} : data;
        data["subTaskID"] = this.subTaskID !== undefined ? this.subTaskID : null;
        data["title"] = this.title !== undefined ? this.title : null;
        data["done"] = this.done !== undefined ? this.done : null;
        data["created"] = this.created ? this.created.toISOString() : null;
        data["task"] = this.task ? this.task.toJS() : null;
        data["taskID"] = this.taskID !== undefined ? this.taskID : null;
        return data; 
    }

    toJSON() {
        return JSON.stringify(this.toJS());
    }

    clone() {
        const json = this.toJSON();
        return new SubTask(JSON.parse(json));
    }
}

export class SubTask extends SubTaskBase {
    get info() {
        return this.title;
    }
}

export class User { 
    userID: number; 
    userName?: string; 
    passwordHash?: string; 
    token?: string; 
    salt?: string; 
    created: Date; 
    lastActivity?: Date; 
    memo?: string; 
    maxTasks?: number; 
    categorySet?: Category[]; 
    client?: Client; 
    clientID?: string;
    constructor(data?: any) {
        if (data !== undefined) {
            this.userID = data["userID"] !== undefined ? data["userID"] : null;
            this.userName = data["userName"] !== undefined ? data["userName"] : null;
            this.passwordHash = data["passwordHash"] !== undefined ? data["passwordHash"] : null;
            this.token = data["token"] !== undefined ? data["token"] : null;
            this.salt = data["salt"] !== undefined ? data["salt"] : null;
            this.created = data["created"] ? new Date(data["created"].toString()) : null;
            this.lastActivity = data["lastActivity"] ? new Date(data["lastActivity"].toString()) : null;
            this.memo = data["memo"] !== undefined ? data["memo"] : null;
            this.maxTasks = data["maxTasks"] !== undefined ? data["maxTasks"] : null;
            if (data["categorySet"] && data["categorySet"].constructor === Array) {
                this.categorySet = [];
                for (let item of data["categorySet"])
                    this.categorySet.push(Category.fromJS(item));
            }
            this.client = data["client"] ? Client.fromJS(data["client"]) : null;
            this.clientID = data["clientID"] !== undefined ? data["clientID"] : null;
        }
    }

    static fromJS(data: any): User {
        return new User(data);
    }

    toJS(data?: any) {
        data = data === undefined ? {} : data;
        data["userID"] = this.userID !== undefined ? this.userID : null;
        data["userName"] = this.userName !== undefined ? this.userName : null;
        data["passwordHash"] = this.passwordHash !== undefined ? this.passwordHash : null;
        data["token"] = this.token !== undefined ? this.token : null;
        data["salt"] = this.salt !== undefined ? this.salt : null;
        data["created"] = this.created ? this.created.toISOString() : null;
        data["lastActivity"] = this.lastActivity ? this.lastActivity.toISOString() : null;
        data["memo"] = this.memo !== undefined ? this.memo : null;
        data["maxTasks"] = this.maxTasks !== undefined ? this.maxTasks : null;
        if (this.categorySet && this.categorySet.constructor === Array) {
            data["categorySet"] = [];
            for (let item of this.categorySet)
                data["categorySet"].push(item.toJS());
        }
        data["client"] = this.client ? this.client.toJS() : null;
        data["clientID"] = this.clientID !== undefined ? this.clientID : null;
        return data; 
    }

    toJSON() {
        return JSON.stringify(this.toJS());
    }

    clone() {
        const json = this.toJSON();
        return new User(JSON.parse(json));
    }
}

export class Client { 
    clientID: string; 
    name?: string; 
    company?: string; 
    eMail?: string; 
    created: Date; 
    deleted?: Date; 
    memo?: string; 
    type?: string; 
    userSet?: User[];
    constructor(data?: any) {
        if (data !== undefined) {
            this.clientID = data["clientID"] !== undefined ? data["clientID"] : null;
            this.name = data["name"] !== undefined ? data["name"] : null;
            this.company = data["company"] !== undefined ? data["company"] : null;
            this.eMail = data["eMail"] !== undefined ? data["eMail"] : null;
            this.created = data["created"] ? new Date(data["created"].toString()) : null;
            this.deleted = data["deleted"] ? new Date(data["deleted"].toString()) : null;
            this.memo = data["memo"] !== undefined ? data["memo"] : null;
            this.type = data["type"] !== undefined ? data["type"] : null;
            if (data["userSet"] && data["userSet"].constructor === Array) {
                this.userSet = [];
                for (let item of data["userSet"])
                    this.userSet.push(User.fromJS(item));
            }
        }
    }

    static fromJS(data: any): Client {
        return new Client(data);
    }

    toJS(data?: any) {
        data = data === undefined ? {} : data;
        data["clientID"] = this.clientID !== undefined ? this.clientID : null;
        data["name"] = this.name !== undefined ? this.name : null;
        data["company"] = this.company !== undefined ? this.company : null;
        data["eMail"] = this.eMail !== undefined ? this.eMail : null;
        data["created"] = this.created ? this.created.toISOString() : null;
        data["deleted"] = this.deleted ? this.deleted.toISOString() : null;
        data["memo"] = this.memo !== undefined ? this.memo : null;
        data["type"] = this.type !== undefined ? this.type : null;
        if (this.userSet && this.userSet.constructor === Array) {
            data["userSet"] = [];
            for (let item of this.userSet)
                data["userSet"].push(item.toJS());
        }
        return data; 
    }

    toJSON() {
        return JSON.stringify(this.toJS());
    }

    clone() {
        const json = this.toJSON();
        return new Client(JSON.parse(json));
    }
}

export class SwaggerException extends Error {
    message: string;
    status: number; 
    response: string; 
    result?: any; 

    constructor(message: string, status: number, response: string, result?: any) {
        super();

        this.message = message;
        this.status = status;
        this.response = response;
        this.result = result;
    }
}