﻿module OpTyp
open System


// definiert alle möglichen binären Operationen
type public BinaryOp =
    | Add 
    | Sub
    | Mul
    | Div
    | Pow

// definiert alle möglichen unnären Operationen 
type public UnaryOp =
    | Sin
    | Cos
    | Tan
    | Sqr
    | Lg

// mögliche Baumstrukturen
type public Tree =
   | NodeOfBinaryOp of BinaryOp * Tree * Tree
   | NodeOfUnaryOp of UnaryOp * Tree
   | Value of double
   | VariableX
   | Pi
   | OtherTerm of String
   | Error

