using System;

namespace TestApplication
{	
	partial class TestForm:	System.Windows.Forms.Form
	{
      
        public TestForm()
		{
		    InitializeComponent();
		}

        private void btnCalc_Click(object sender, EventArgs e)
        {
            if ((textBoxTerm.Text != "")&&(textBoxWert.Text!=""))
            {
                labelFehler.Text = "";
                string term = textBoxTerm.Text;
                ParserInCSharp.MathFunction function = new ParserInCSharp.MathFunction(term);
                ParserInCSharp.ErrorTyp error = function.Error;
                switch (error)
                {
                    case ParserInCSharp.ErrorTyp.No:
                        ParserInCSharp.Calc calc = new ParserInCSharp.Calc(function);
                        try
                        {
                            double x = double.Parse(textBoxWert.Text);
                            double result = calc.CalcValue(x);
                            textBoxErgebnis.Text = result.ToString();
                            labelFehler.Text = "OK";
                        }
                        catch { }
                        break;
                    case ParserInCSharp.ErrorTyp.Resolve:
                        labelFehler.Text = "Error in Term";
                        break;
                }
             }
        }

        private void btnCalculateWithFSharp_Click(object sender, EventArgs e)
        {
            if ((textBoxTerm.Text != "") && (textBoxWert.Text != ""))
            {
                try
                {
                    labelFehler.Text = "";
                    string term = textBoxTerm.Text;
                    double x = double.Parse(textBoxWert.Text);
                    OpTyp.Tree tree = ParserInFSharp.MathFunction(term);
                    double result = Calc.Calc(tree, x);
                    textBoxErgebnis.Text = result.ToString();
                }
                catch { }

            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            textBoxErgebnis.Text = "";
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            textBoxErgebnis.Text = "";
            textBoxTerm.Text = "";
            textBoxWert.Text = "";
        }
    }
}