﻿using System;

namespace ParserInCSharp
{
    public class Calc
    {
        public ErrorTyp Error { private set; get; }

        private MathFunction f;
        public Calc (MathFunction function)
        {
            f = function;
        }

        public double CalcValue(double x)
        {
            double result = 0;
            double value1;
            double value2;
            if ((f.Typ == OpTyp.Div) || (f.Typ == OpTyp.Sub) || (f.Typ == OpTyp.Mul)
                || (f.Typ == OpTyp.Add) || (f.Typ == OpTyp.Pow))
            {
                Calc calcLeft = new Calc(f.ChildLeft);
                value1 = calcLeft.CalcValue(x);
                Calc calcRight = new Calc(f.childRight);
                value2 = calcRight.CalcValue(x);

              
                if ((f.ChildLeft.Error == ErrorTyp.No) && (f.ChildLeft.Error == ErrorTyp.No))
                {
                    switch (f.Typ)
                    {
                        case OpTyp.Add:
                            result = value1 + value2;
                            break;
                        case OpTyp.Sub:
                            result = value1 - value2;
                            break;
                        case OpTyp.Mul:
                            result = value1 * value2;
                            break;
                        case OpTyp.Div:
                            if (value2 != 0)
                                result = value1 / value2;
                            else
                                Error = ErrorTyp.Calc;
                            break;
                        case OpTyp.Pow:
                            result = Math.Pow(value1, value2);
                            if (
                                (double.IsNaN(result) == true) ||
                                (double.IsInfinity(result) == true) ||
                                (double.IsNegativeInfinity(result) == true) ||
                                (double.IsPositiveInfinity(result) == true))
                            {
                                Error = ErrorTyp.Calc;
                            }
                            break;
                    }
                }
                else
                {
                    Error = ErrorTyp.Calc;
                }
            }
            else if (f.Typ == OpTyp.Sin)
            {
                Calc calcLeft = new Calc(f.ChildLeft);
                value1 = calcLeft.CalcValue(x);
                result = Math.Sin(value1);
            }
            else if (f.Typ == OpTyp.Cos)
            {
                Calc calcLeft = new Calc(f.ChildLeft);
                value1 = calcLeft.CalcValue(x);
                result = Math.Cos(value1);
            }
            else if (f.Typ == OpTyp.Tan)
            {
                try
                {
                    Calc calcLeft = new Calc(f.ChildLeft);
                    value1 = calcLeft.CalcValue(x);
                    result = Math.Tan(value1);
                }
                catch
                {
                    Error = ErrorTyp.Calc;
                }
            }
            else if (f.Typ == OpTyp.Sqr)
            {
                Calc calcLeft = new Calc(f.ChildLeft);
                value1 = calcLeft.CalcValue(x);
                if (value1 >= 0)
                {
                    result = Math.Sqrt(value1);
                }
                else
                {
                    Error = ErrorTyp.Calc;
                }
            }
            else if (f.Typ == OpTyp.Lg)
            {
                Calc calcLeft = new Calc(f.ChildLeft);
                value1 = calcLeft.CalcValue(x);
                if (value1 >= 0)
                {
                    result = Math.Log10(value1);
                }
                else
                {
                    Error = ErrorTyp.Calc;
                }
            }

            else if (f.Typ == OpTyp.Fak)
            {
                Calc calcLeft = new Calc(f.ChildLeft);
                value1 = calcLeft.CalcValue(x);
                if (value1 >= 0)
                {
                    if (value1 == 0) result = 1;
                    else if (value1 == 1) result = 1;
                    else
                    {
                        result = value1;
                        for (long i = ((int)(value1) - 1); i > 0; i--)
                        {
                            result *= i;
                        }
                    }
                }
                else
                {
                    Error = ErrorTyp.Calc;
                }
            }
            else if (f.Typ == OpTyp.Var) result = x;
            else if (f.Typ == OpTyp.Pi) result = Math.PI;
            else if (f.Typ == OpTyp.Num) result = double.Parse(f.Term);
            return result;
        }
    }
}
