use DWH_TEST
go

set ansi_nulls on
go

set quoted_identifier on
go

if exists (select 1 from sys.procedures SP where SP.schema_id=schema_id('Staging') and SP.name='spMergeDimProduct')
	drop procedure Staging.spMergeDimProduct
go

create procedure Staging.spMergeDimProduct
	@OneBusinessKey varchar(10) = null as
begin

	begin try

		begin transaction

			-- Schleife ber alle Business-Keys, welche in Staging-Tabelle vorliegen
			-- (ggf. gefiltert fr einen vorgegebenen Business-Key)

			declare AllBusinessKeys cursor local fast_forward for
				select distinct ProductID
					from Staging.Product
					where ProductID=isnull(@OneBusinessKey, ProductID)
					order by 1

			declare @BusinessKey varchar(10)

			open AllBusinessKeys
			fetch next from AllBusinessKeys into @BusinessKey

			while @@fetch_status=0
				begin
					-- Schleife ber alle Datenstze eines BKs
					-- Sortiert nach Datum
					-- Tag fr Tag, aus der Vergangenheit in die Zukunft
										
					declare StagingDates cursor local fast_forward for
						select [Date]
							from Staging.Product
							where ProductID=@BusinessKey
							order by 1

					declare @Date date

					open StagingDates
					fetch next from StagingDates into @Date

					while @@fetch_status=0
						begin
							-- 1. Gibt es in der Zieltabelle bereits Row fr diesen Zeitraum?

							declare @DWHRowId bigint = -- Identifier des bereits in DWH (Dimensions-Tabelle) existierenden Datensatzes
								(
									select DWH_ProductID
										from DWH.DimProduct
										where
											ProductID=@BusinessKey and
											@Date between InDate and isnull(dateadd(day, -1, OutDate), getdate())
								)

							if @DWHRowId is null -- Row gibt es nicht --> erstellen!
								begin
									insert into DWH.DimProduct (ProductID, Name, Material, Hall, Shelf, InDate, OutDate)
										select
											ProductID, Name, Material, Hall, Shelf,
											[Date], (select min(InDate) from DWH.DimProduct where ProductID=@BusinessKey)
										from Staging.Product
										where ProductID=@BusinessKey and [Date]=@Date

									set @DWHRowId = scope_identity()
								end

							-- 2. Changing Attributes
							/*
								Name
							*/

							update T
								set
									T.Name=S.Name
								from
									DWH.DimProduct T
										inner join Staging.Product S on
											T.ProductID=S.ProductID and
											T.CS_Changing<>S.CS_Changing
								where
									S.ProductID=@BusinessKey and
									S.[Date]=@Date

							-- 3. Historical Attributes
							/*
								Material
								Hall
								Shelf
							*/

							if
									(select CS_Historical from DWH.DimProduct where DWH_ProductID=@DWHRowId)<>
									(select CS_Historical from Staging.Product where ProductID=@BusinessKey and [Date]=@Date)
								begin

									declare
										@OldInDate date,
										@OldOutDate date,
										@NewRowId bigint

									select @OldInDate=InDate, @OldOutDate=OutDate
										from DWH.DimProduct
										where DWH_ProductID=@DWHRowId

									-- Fall 1: das existierende Intervall umfasst exakt einen Tag
									-- Lsung: die Werte ersetzen
									if @OldInDate=@Date and @OldOutDate=dateadd(day, 1, @Date)
										begin
											update T
												set
													T.Material=S.Material,
													T.Hall=S.Hall,
													T.Shelf=S.Shelf
												from
													DWH.DimProduct T
														cross join Staging.Product S
												where
													T.DWH_ProductID=@DWHRowId and
													S.ProductID=@BusinessKey and
													S.[Date]=@Date
										end

									else
									
									-- Fall 2: der neue Datensatz liegt exakt an der linken Grenze des exist. Intervalls
									-- Lsung: links einen 1-Tag-Intervall hinzufgen
									if @OldInDate=@Date
										begin
											-- existierendes Intervall von links um einen Tag krzen
											update T
												set T.InDate=dateadd(day, 1, @Date)
												from DWH.DimProduct T
												where T.DWH_ProductID=@DWHRowId

											-- neues Intervall hinzufgen
											insert into DWH.DimProduct (ProductID, Name, Material, Hall, Shelf, InDate, OutDate)
												select
													ProductID, Name, Material, Hall, Shelf,
													[Date], dateadd(day, 1, [Date])
												from Staging.Product
												where ProductID=@BusinessKey and [Date]=@Date

											set @NewRowId = scope_identity()

											-- Adjustierung: Facts fr den betroffenen Tag auf den neuen DWH-Key umhngen
											update T
												set T.DWH_ProductID=@NewRowId
												from DWH.FactOrder T
												where T.DWH_ProductID=@DWHRowId and T.[Date]=@Date
										end

									else

									-- Fall 3: der neue Datensatz liegt exakt an der rechten Grenze des exist. Intervalls
									-- Lsung: rechts einen 1-Tag-Intervall hinzufgen

									if @OldOutDate=dateadd(day, 1, @Date) or @OldOutDate is null
										begin
											-- existierendes Intervall von rechts um einen Tag krzen
											update T
												set T.OutDate=@Date
												from DWH.DimProduct T
												where T.DWH_ProductID=@DWHRowId

											-- neues Intervall hinzufgen
											insert into DWH.DimProduct (ProductID, Name, Material, Hall, Shelf, InDate, OutDate)
												select
													ProductID, Name, Material, Hall, Shelf,
													[Date], @OldOutDate
												from Staging.Product
												where ProductID=@BusinessKey and [Date]=@Date

											set @NewRowId = scope_identity()

											-- Adjustierung: Facts fr den betroffenen Tag auf den neuen DWH-Key umhngen
											-- Warum hier ">=@Date"? Weil wir auch den Fall mitbetrachten mssen,
											-- wenn das existierende, von rechts begrenzte Intervall bis "+unendlich" galt!
											update T
												set T.DWH_ProductID=@NewRowId
												from DWH.FactOrder T
												where T.DWH_ProductID=@DWHRowId and T.[Date]>=@Date
										end

									else

									-- Fall 4: der neue Datensatz fllt in die Mitte eines lngeren Intervalls
									-- Lsung: Intervall teilen

										begin
											declare @NewRowId2 bigint

											-- existierendes Intervall nun als "linken"
											-- Teil betrachten und begrenzen
											update T
												set T.OutDate=@Date
												from DWH.DimProduct T
												where T.DWH_ProductID=@DWHRowId

											-- 1-Tag-Intervall hinzufgen
											insert into DWH.DimProduct (ProductID, Name, Material, Hall, Shelf, InDate, OutDate)
												select
													ProductID, Name, Material, Hall, Shelf,
													[Date], dateadd(day, 1, [Date])
												from Staging.Product
												where ProductID=@BusinessKey and [Date]=@Date

											set @NewRowId = scope_identity()

											-- einen neuen "rechten" Teil hinzufgen,
											-- als Duplikat des "linken" Teils im Bereich der Attribute,
											-- aber mit anderen Einstellungen fr InDate und OutDate
											insert into DWH.DimProduct (ProductID, Name, Material, Hall, Shelf, InDate, OutDate)
												select
													ProductID, Name, Material, Hall, Shelf,
													dateadd(day, 1, @Date), @OldOutDate
												from DWH.DimProduct
												where DWH_ProductID=@DWHRowId

											set @NewRowId2 = scope_identity()

											-- Adjustierung aus zwei Schritten:

											-- Adjustierung: Facts fr den betroffenen Tag auf den neuen DWH-Key umhngen
											update T
												set T.DWH_ProductID=@NewRowId
												from DWH.FactOrder T
												where T.DWH_ProductID=@DWHRowId and T.[Date]=@Date

											-- Adjustierung: Facts fr die Tage NACH dem betroffenen Tag auf deb neuen DWH-Key 2 umhngen
											update T
												set T.DWH_ProductID=@NewRowId2
												from DWH.FactOrder T
												where T.DWH_ProductID=@DWHRowId and T.[Date]>@Date
										end

								end

							-- zum nchsten Datum
							fetch next from StagingDates into @Date
						end

					deallocate StagingDates

					-- zum nchsten Business-Key
					fetch next from AllBusinessKeys into @BusinessKey
				end

			deallocate AllBusinessKeys

		commit transaction

	end try

	begin catch
		if @@trancount<>0
			begin
				print 'Active transacton is being rolled back.'
				rollback transaction
			end
		declare @EN integer, @EM varchar(max), @Msg varchar(max)
		set @EN = error_number()
		set @EM = error_message()
		set @Msg = 'Server error ' + convert(varchar, @EN) + ' encountered: ' + @EM
		raiserror(@Msg, 16, 1)
	end catch

end
go
