use DWH_TEST
go

create schema Staging
go

create schema DWH
go

create table Staging.Product (
	ProductID varchar(10) not null,
	[Date] date not null,
	Name varchar(100),
	Material varchar(50),
	Hall varchar(10),
	Shelf varchar(10),
	
	CS_Changing as
		binary_checksum(Name) persisted,
	CS_Historical as
		binary_checksum(Material, Hall, Shelf) persisted,
	
	constraint PK_Staging_Product
		primary key (ProductID, [Date])
)
go

create table DWH.DimProduct (
	DWH_ProductID bigint not null identity,
	ProductID varchar(10) not null,

	Name varchar(100),
	Material varchar(50),
	Hall varchar(10),
	Shelf varchar(10),

	InDate date not null,
	OutDate date null,

	CS_Changing as
		binary_checksum(Name) persisted,
	CS_Historical as
		binary_checksum(Material, Hall, Shelf) persisted,
	
	constraint PK_DWH_DimProduct
		primary key (DWH_ProductID)
)
go

create table DWH.FactOrder (
	[Date] date not null,
	DWH_ProductID bigint not null,
	UnitCount integer,
	UnitCost float,
	UnitPrice float,
	
	constraint FK_DWH_FactOrder_DWH_DimProduct
		foreign key (DWH_ProductID)
		references DWH.DimProduct(DWH_ProductID)
		on update no action
		on delete no action
)
go
