import numpy as np
import matplotlib.pyplot as plt
import tensorflow as tf
import xlrd

DATA_FILE = 'immo_preis.xls'

# Daten einlesen
def read_data(filename):
    book = xlrd.open_workbook(filename, encoding_override = "utf-8")
    sheet = book.sheet_by_index(0)
    x_data = np.asarray([sheet.cell(i, 1).value for i in range(1, sheet.nrows)])
    y_data = np.asarray([sheet.cell(i, 2).value for i in range(1, sheet.nrows)])
    return x_data, y_data

x_data, y_data = read_data(DATA_FILE)

# Modell definieren
with tf.name_scope('model'):
    W = tf.Variable([0.0], name = 'Weights')
    b = tf.Variable([0.0], name = 'biases')
    y = W * x_data + b
    
# Training-Graph
with tf.name_scope('train'):
    loss = tf.reduce_mean(tf.square(y - y_data), name = 'loss') 

    tf.summary.scalar('loss',loss)
    optimizer = tf.train.GradientDescentOptimizer(0.0001)
    train = optimizer.minimize(loss)
    
#Lernen
summary_op = tf.summary.merge_all()
print(summary_op)
with tf.Session() as session:
    writer  =  tf.summary.FileWriter('./linear_log', session.graph)
    init = tf.global_variables_initializer()
    session.run(init)
    
    #Training
    for i in range(10000):
        summary, _ = session.run([summary_op, train])
        writer.add_summary(summary, i)

    #Bewerten
    curr_W, curr_b, curr_loss  = session.run([W, b, loss])
    print("W: %s b: %s loss: %s"%(curr_W, curr_b, curr_loss))
    
writer.close()