// Doppelpyramide
module dp(d=5){
    for(m=[0,1])
        mirror([0,0,m])
            cylinder(d1=d,d2=0,h=d/2,$fn=4);
}
module mcube(v=[1,1,1],center=false,d=5){
    translate(center?[0,0,0]:[d/2,d/2,d/2])
        minkowski(){
            cube([v[0]-d,v[1]-d,v[2]-d],center=center);
            dp(d=d);
        }
}
// Box ohne Deckel
module box(){
    difference(){
        mcube([50,50,50],d=10,center=true);
        translate([0,0,5]) mcube([40,40,55],d=10,center=true);
        translate([0,0,45]) cube([40,40,55],center=true);
    }
}

// Deckel
module deckel(){
    translate([0,0,50]) cube([39.5,39.5,5],center=true);
}
box();
deckel();