﻿
using System;
using Wisej.Web;

namespace Calc
{
    public partial class Page1 : Page
    {
        public Page1()
        {
            InitializeComponent();
        }

        private void buttonCalc_Click(object sender, EventArgs e)
        {
            // Daten aus dem Formular lesen
            DataInputItem inputData = ReadData();

            // ValidateData();

            // Algorithmus: Kredit berechnen
            DataOutputItem[] outputData = Calc(inputData);
            Calc(inputData);

            // Anzeige in der View
            ShowData(outputData);
        }

        private DataInputItem ReadData()
        {
            double kreditBetrag = double.Parse(textBoxKerditbetrag.Text);
            double zinsSatz = double.Parse(textBoxZinsatz.Text);
            double tilgungsSatz = double.Parse(textBoxTilgungssatz.Text);
            int laufzeit = int.Parse(textBoxLaufzeit.Text);
            DataInputItem item = new DataInputItem(kreditBetrag, tilgungsSatz, zinsSatz, laufzeit);
            return item;
        }

        private DataOutputItem[] Calc(DataInputItem Item)
        {
            double zinsSatz = Item.Zinsatz;
            double tilgungssatz = Item.Tilgungssatz;
            double kreditBetrag = Item.KreditBetrag;
            int laufzeit = Item.Laufzeit;

            // t=1
            double tilgung = kreditBetrag * tilgungssatz / 100;
            double zinsen = kreditBetrag * zinsSatz / 100;
            double anuitaet = tilgung + zinsen;
            double restschuld = kreditBetrag - tilgung;

            DataOutputItem[] output = new DataOutputItem[laufzeit];

            DataOutputItem item1 = new DataOutputItem(kreditBetrag, zinsen, tilgung, restschuld);
            output[0] = item1;


            for (int i = 1; i < laufzeit; i++)
            {
                DataOutputItem item = output[i - 1];
                double aktuellerKreditBetrag = item.RestBetrag;
                double aktuelleZinsen = item.RestBetrag * zinsSatz / 100;
                double aktuelleTilgung = anuitaet - aktuelleZinsen;
                double aktuellerRestbetrag = aktuellerKreditBetrag - aktuelleTilgung;

                DataOutputItem itemI = new DataOutputItem(aktuellerKreditBetrag, aktuelleZinsen, aktuelleTilgung, aktuellerRestbetrag);
                output[i] = itemI;
            }
            return output;
        }

        private void ShowData(DataOutputItem[] Data)
        {
            dataGridView1.RowCount = Data.Length;
            for (int i = 0; i < Data.Length; i++)
            {
                dataGridView1.Rows[i].Cells[0].Value = (i + 1).ToString();
                dataGridView1.Rows[i].Cells[1].Value = Data[i].AktuellerKreditBetrag.ToString("#.00");
                dataGridView1.Rows[i].Cells[2].Value = Data[i].Tilgung.ToString("#.00");
                dataGridView1.Rows[i].Cells[3].Value = Data[i].Zins.ToString("#.00");
                dataGridView1.Rows[i].Cells[4].Value = Data[i].RestBetrag.ToString("#.00");
            }


        }
        private DataInputItem ValidateData(DataInputItem Item)
        {
            return Item;
        }
    }
}
