// Backbone für den Schraub-Service erzeugen
TighteningService tighteningService;

// Eine Operation anlegen
Operation op;
op.setIdShort("tightenOp");
       
// Eingangsparameter festlegen
op.addParameter<std::string>("ProgramNo");
op.addParameter<int>("Times");

// Die Ausgangsvariable konfigurieren
op.setReturnType<bool>("TighteningSuccess");

/* Die Funktion mittels einer Hilfs-Methode der Operation zuweisen und das Ergebnis per Lambda-Funktion in einen Result Wrapper stecken */
op.setInvocable(basyx::object::make_function([&tighteningService](const std::string& s, int n) -> basyx::object {
    bool result = tighteningService.tightenTimes(s, n);
    basyx::object resultWrapper = basyx::object::make_map();
    resultWrapper.insertKey("TighteningSuccess", result);
    return resultWrapper;
}));
