public class TighteningResultSubmodel : Submodel
{
    /* MQTT-Client für Kommunikation der Ergebnisse erzeugen */
    private MqttClient mqttClient;
    /* Properties festlegen */
    public TighteningResultSubmodel(MqttClient mqttClient) : base()
    {
        this.mqttClient = mqttClient;
        IdShort = "TighteningResult";
        Identification = new Identifier(Guid.NewGuid().ToString(), KeyType.Custom);
        SubmodelElements = new ElementContainer<ISubmodelElement>
        {
            new SubmodelElementCollection()
            {
                IdShort = "LastTighteningResult",
                Value = new ElementContainer<ISubmodelElement>()
                {
                    new Property<string>()   { IdShort = "programNumber" },
                    new Property<bool>()     { IdShort = "tighteningStatus" },
                    new Property<float>()    { IdShort = "targetTorque" },
                    new Property<float>()    { IdShort = "torque" },
                    new Property<DateTime>() { IdShort = "timestamp" }
                }
            }
        };
    }
    /* TighteningResult updaten und Informationen über MQTT weitergeben */
    internal void UpdateTighteningResult(TighteningResult tighteningResult)
    {
        var collection = SubmodelElements["LastTighteningResult"] as SubmodelElementCollection;
        (collection.Value["programNumber"] as IProperty).Value = tighteningResult.ProgramNumber;
        (collection.Value["tighteningStatus"] as IProperty).Value = tighteningResult.TighteningStatus;
        (collection.Value["targetTorque"] as IProperty).Value = tighteningResult.TargetTorque;
        (collection.Value["torque"] as IProperty).Value = tighteningResult.Torque;
        (collection.Value["timestamp"] as IProperty).Value = tighteningResult.Timestamp;
        string serializedResult = JsonConvert.SerializeObject(tighteningResult, Formatting.Indented);
        byte[] bMessage = Encoding.UTF8.GetBytes(serializedResult);
        mqttClient.Publish("/NexoNutrunner/NewTighteningResult", bMessage);
    }
}
