package org.eclipse.basyx.iX.tutorial3;

import org.eclipse.basyx.submodel.metamodel.map.SubModel;
import org.eclipse.basyx.submodel.metamodel.map.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.property.Property;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

import com.google.gson.Gson;

public class TighteningResultSubmodel extends SubModel {
    /* MQTT-Client für Kommunikation der Ergebnisse erzeugen */
    private MqttClient mqttClient;

    // Properties der SubmodelElementCollection festlegen
    private Property programNr, tighteningStatus, targetTorque, torque, timestamp;

    public TighteningResultSubmodel(MqttClient mqttClient) {
        this.mqttClient = mqttClient;

        /* Identifikationsdaten des Submodels setzen */
        setIdShort("TighteningResult");
        setIdentification("TighteningResult", IdentifierType.Custom);

        // Properties initialisieren
        programNr = new Property("");
        programNr.setIdShort("programNumber");

        tighteningStatus = new Property(false);
        tighteningStatus.setIdShort("tighteningStatus");

        targetTorque = new Property(0.0);
        targetTorque.setIdShort("targetTorque");

        torque = new Property(0.0);
        torque.setIdShort("torque");

        timestamp = new Property("2019-12-02T13:00:00");
        timestamp.setIdShort("timestamp");

        /* Die SubmodelElementCollection erzeugen und die Properties darin ablegen */
        SubmodelElementCollection collection = new SubmodelElementCollection();
        collection.setIdShort("LastTighteningResult");
        collection.addElement(programNr);
        collection.addElement(tighteningStatus);
        collection.addElement(targetTorque);
        collection.addElement(torque);
        collection.addElement(timestamp);
        addSubModelElement(collection);
    }

    /* TighteningResult updaten und Informationen über MQTT weitergeben */
    public void updateTighteningResult(TighteningResult tighteningResult) throws MqttPersistenceException, MqttException {

        // Properties mit den neuen Daten updaten
        programNr.set(tighteningResult.programNumber);
        tighteningStatus.set(tighteningResult.tighteningStatus);
        targetTorque.set(tighteningResult.targetTorque);
        torque.set(tighteningResult.torque);
        timestamp.set(tighteningResult.timestamp);

        System.out.println("Value updated!");

        // Neue Daten per MQTT publizieren
        String serialized = new Gson().toJson(tighteningResult);
        mqttClient.publish("NexoNutrunner/NewTighteningResult", new MqttMessage(serialized.getBytes()));
    }
}

