// Schrauberanbindung simulieren
public class TighteningService
{
    // Zufallsquellen für Schraubsimulation
    Random randomTorque;
    Random randomDelay;
    // Simulation konfigurieren
    public const float TargetTorque = 20.0f;
    public const float Deviation = 0.10f;
    public const float SimulatedDeviation = 1.3f;
    private TighteningResultSubmodel tighteningResultSubmodel;
    public void Initialize(TighteningResultSubmodel tighteningResultSubmodel)
    {
        this.tighteningResultSubmodel = tighteningResultSubmodel;
        randomTorque = new Random();
        randomDelay = new Random();
    }
    // Schraubergebnis erzeugen
    public bool Tighten(string programNo)
    {
        // minimales und maximales Drehmoment festlegen
        float maxTorque = (1.0f + Deviation) * TargetTorque;
        float minTorque = (1.0f - Deviation) * TargetTorque;
        // Zufälligen Drehmoment berechnen
        float torqueRange = maxTorque - minTorque;
        float fRandomTorque = minTorque + (float)(randomTorque.NextDouble() * torqueRange * SimulatedDeviation);
        // Schrauberfolg basierend auf Drehmoment festlegen
        bool tighteningSuccess = minTorque <= fRandomTorque && fRandomTorque <= maxTorque;
        // Daten in TighteningResult ablegen
        TighteningResult tighteningResult = new TighteningResult()
        {
            ProgramNumber = programNo,
            TighteningStatus = tighteningSuccess,
            Timestamp = DateTime.Now,
            TargetTorque = TargetTorque,
            Torque = fRandomTorque
        };
        tighteningResultSubmodel.UpdateTighteningResult(tighteningResult);
        return tighteningSuccess;
    }
    /* Hilfsfunktion zum mehrfachen Aufruf der tighten()-Funktion */
    public bool TightenTimes(string programNo, int times)
    {
        bool[] successes = new bool[times];
        for (int i = 0; i < times; i++)
        {
            successes[i] = Tighten(programNo);
            int delay = randomDelay.Next(2, 5) * 1000;
            Thread.Sleep(delay);
        }
        return successes.ToList().TrueForAll(s => s == true);
    }
}
[DataContract]
public class TighteningResult
{      
    [DataMember(EmitDefaultValue = false, IsRequired = false, Name = "programNumber", Order = 1)]
    public string ProgramNumber { get; set; }
    [DataMember(EmitDefaultValue = true, IsRequired = true, Name = "tighteningStatus", Order = 2)]
    public bool TighteningStatus { get; set; }
    [DataMember(EmitDefaultValue = false, IsRequired = false, Name = "targetTorque", Order = 3)]
    public float TargetTorque { get; set; }
    [DataMember(EmitDefaultValue = false, IsRequired = false, Name = "torque", Order = 4)]
    public float Torque { get; set; }
    [DataMember(EmitDefaultValue = false, IsRequired = false, Name = "timestamp", Order = 5)]
    public DateTime Timestamp { get; set; }
}
