package org.eclipse.basyx.iX.tutorial3;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Random;

import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

// Schrauberanbindung simulieren
public class TighteningService {
    // Zufallsquellen für Schraubsimulation
    Random randomTorque;
    Random randomDelay;
    // Simulation konfigurieren
    public double TargetTorque = 20.0f;
    public double Deviation = 0.13f;
    public double SimulatedDeviation = 1.3f;
    private TighteningResultSubmodel tighteningResultSubmodel;
    public TighteningService(TighteningResultSubmodel tighteningResultSubmodel) {
        this.tighteningResultSubmodel = tighteningResultSubmodel;
        randomTorque = new Random();
        randomDelay = new Random();
    }
    // Schraubergebnis erzeugen
    public boolean tighten(String programNo) throws MqttPersistenceException, MqttException {
        // minimales und maximales Drehmoment festlegen
        double maxTorque = (1.0f + Deviation) * TargetTorque;
        double minTorque = (1.0f - Deviation) * TargetTorque;
        // Zufälligen Drehmoment berechnen
        double torqueRange = maxTorque - minTorque;
        double fRandomTorque = minTorque + randomTorque.nextDouble() * torqueRange * SimulatedDeviation;
        // Schrauberfolg basierend auf Drehmoment festlegen
        boolean tighteningSuccess = minTorque <= fRandomTorque && fRandomTorque <= maxTorque;
        // Aktuellen Timestamp erzeugen
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy'T'HH:mm:ss");
        String timestamp = formatter.format(calendar.getTime());
        // Daten in TighteningResult ablegen
        TighteningResult tighteningResult = new TighteningResult();
        tighteningResult.programNumber = programNo;
        tighteningResult.tighteningStatus = tighteningSuccess;
        tighteningResult.timestamp = timestamp;
        tighteningResult.targetTorque = TargetTorque;
        tighteningResult.torque = fRandomTorque;

    tighteningResultSubmodel.updateTighteningResult(tighteningResult);
        return tighteningSuccess;
    }
    /* Hilfsfunktion zum mehrfachen Aufruf der tighten()-Funktion */
    public boolean tightenTimes(String programNo, int times) throws MqttPersistenceException, MqttException, InterruptedException {
        boolean success = true;
        for (int i = 0; i < times; i++) {
            success &= tighten(programNo);
            int delay = (randomDelay.nextInt(5) + 2) * 1000;
            Thread.sleep(delay);
        }
        return success;
    }
}
