class Program
{
    static void Main(string[] args)
    {
        /* MQTT-Client zu einem lokalen MQTT-Broker erstellen */
        MqttClient mqttClient = new MqttClient("localhost");
        /* Verbindung zum MQTT-Broker mit einer zufällig erzeugten GUID als Client-ID herstellen */
        mqttClient.Connect(Guid.NewGuid().ToString());
        /* Schraubergebnis-Teilmodell initialisieren */
        TighteningResultSubmodel tighteningResultSubmodel = new TighteningResultSubmodel(mqttClient);
        /* Konfigurationsparameter für den Server erzeugen */
        ServerSettings serverSettings = ServerSettings.CreateSettings();
        /*IP-Adresse und Port des Raspberry PI angeben */
        serverSettings.ServerConfig.Hosting.Urls.Add("http://+:5123");
        /* Pfad zu weiteren Inhalten auf dem Server bestimmen */
        serverSettings.ServerConfig.Hosting.ContentPath = "Content";
        /* Generischen Service-Provider für das Schraubergebnis-Teilmodell erzeugen */
        ISubmodelServiceProvider submodelServiceProvider = tighteningResultSubmodel.CreateServiceProvider();
        /* Generischen HTTP/REST-Server für ein Teilmodell initialisieren und mit den Server-Konfigurationsparametern laden */
        SubmodelRestLoader loader = new SubmodelRestLoader(serverSettings);
        /* Verwaltungsschalen-Service-Provider dem generischen HTTP/REST-Server zuweisen */
        loader.SetServiceProvider(submodelServiceProvider);
        /* Server für das Schraubergebnis-Teilmodell starten */
        loader.RunAsync();
        /* Konfigurationsparameter für den Client erzeugen */
        RegistryClientSettings registryClientSettings = RegistryClientSettings.CreateSettings();
        /* IP-Adresse und Port des Registry-Servers angeben */
        registryClientSettings.RegistryConfig.RegistryUrl = "http://192.168.178.21:4999";
        /* Neue Registry-Client-Instanz erzeugen und mit den Konfigurationsparametern laden */
        RegistryClient registryClient = new RegistryClient(registryClientSettings);

        /* Schraubergebnis-Teilmodell bei der Registry unter der jeweiligen Verwaltungsschale registrieren */
        registryClient.CreateSubmodel("http://boschrexroth.com/assets/nutrunner/0608842010/123456790",
            new SubmodelDescriptor(tighteningResultSubmodel,
            new List<IEndpoint>() { new HttpEndpoint("http://192.168.178.13:5123/submodel") }));
        /* Schrauber-Simulation implementieren */
        TighteningService tighteningService = new TighteningService();
        /* Schraubergebnis-Teilmodell der Schrauber-Simulation zuweisen */
        tighteningService.Initialize(tighteningResultSubmodel);
        /* Schrauber-Simulation mit der Nummer "001" 1000 mal starten  */
        tighteningService.TightenTimes("001", 1000);
    }
}
