import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.submodel.restapi.SubModelProvider;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.server.AASHTTPServer;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
public class Program {
    public static void main(String[] args) throws MqttSecurityException, MqttException, InterruptedException {
        /* MQTT-Client mit der Client-ID "publisher" zum lokalen MQTT-Broker erstellen */
        MqttClient mqttClient = new MqttClient("tcp://localhost", "publisher");
        // Konfiguration der Mqtt-Optionen
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(true);
        options.setCleanSession(true);
        options.setConnectionTimeout(10);
        mqttClient.connect(options);
        // Anlegen des TighteningResultSubmodels
        TighteningResultSubmodel tighteningResultSubmodel = new TighteningResultSubmodel(null);
        // Zuweisung des Teilmodells zu einem Teilmodellprovider
        SubModelProvider provider = new SubModelProvider(tighteningResultSubmodel);
        // Servlet aufbauen und Provider einbinden
        BaSyxContext context = new BaSyxContext("", "", "localhost", 5123);
        context.addServletMapping("/*", new VABHTTPInterface<IModelProvider>(provider));
        // Servlet auf Server ablegen und Server starten
        AASHTTPServer httpServer = new AASHTTPServer(context);
        httpServer.start();
        // Registry-Proxy über den Endpunkt erstellen
        AASRegistryProxy registry = new AASRegistryProxy("http://192.168.178.21:4999/");
        // Teilmodell bei der VWS registrieren
        SubmodelDescriptor descriptor = new SubmodelDescriptor(tighteningResultSubmodel, "http://192.168.178.13:5123/submodel");
        registry.register(new ModelUrn("http://boschrexroth.com/assets/nutrunner/0608842010/123456790"), descriptor);
        /* TighteningService erstellen, anschließend 1000 Schraubergebnisse erzeugen */
        TighteningService tighteningService = new TighteningService(tighteningResultSubmodel);
        tighteningService.tightenTimes("001", 1000);
    }
}
